C----------------------------------------------------------------GENESIS
      PROGRAM GENSIS
C
C     *****          COPYRIGHT, 1990-2006             *****
C     ***** VANDERPLAATS RESEARCH & DEVELOPMENT, INC. *****
C     *****     ALL RIGHTS RESERVED, WORLDWIDE        *****
C
C-----------------------------------------------------------------------

      USE GNKIND
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C

C
C-----PARAMETERS: USER DEFINED (SYSTEM DEPENDENT)----------------
C
      PARAMETER (LENVC=50 000 000)
      PARAMETER (NMROW=64)
      PARAMETER (NMCOL=132)
      PARAMETER (LEQMAX=20000)
C
C-----PROGRAM DEPENDENT PARAMETERS-------------------------------
C
      INTEGER, PARAMETER :: LD=2047
      INTEGER, PARAMETER :: MD=4
      INTEGER, PARAMETER :: LVT=2047
      INTEGER, PARAMETER :: MVT=2
C
      INTEGER, PARAMETER :: INTLN=4
C
C-----DECLARATIONS-----------------------------------------------
C
      INTEGER(KIND=LONG) LENVEC
C
      CHARACTER*80 LINE
C
      CHARACTER*1 ESTRNG(LEQMAX)
      CHARACTER*14 LENENV
      CHARACTER*20 CLENVC
C
C-----COMMON BLOCKS---------------------------------------------
C
      INTEGER IVECTR

      COMMON /GNC000/ IVECTR(1)

      DOUBLE PRECISION DVECTR(1)
      EQUIVALENCE (DVECTR, IVECTR)
C 
      INTEGER(KIND=LONG) MOFFST
      COMMON /GNC001/ MOFFST
C
      CHARACTER*72 TITLE, STITLE
      COMMON /GNC00T/ TITLE,STITLE
C
      CHARACTER*1 TABC,COMENT,CSLASH,CHAREX(5)
      COMMON /GNC00C/ TABC,COMENT,CSLASH,CHAREX
C
      CHARACTER*260 FLNAME

      COMMON /GNC00V/ IVERN1,IVERN2,IDATE1,IDATE2,IDATE3,ITIME1,ITIME2
C
      COMMON /GNC00E/ IEXTST, IMXRTW
C
      INTEGER(KIND=LONG) IDICT
      COMMON /GNC02A/ IDICT(LD)
C
      INTEGER(KIND=LONG) IADICT,
     *                   IVTAB0, IVTAB1, IVTAB2,
     *                   LVOID0, LVOID1, LVOID2,
     *                   LENVCC
      INTEGER            INTLEN, NDICT ,
     *                   NVOID0, NVOID1, NVOID2
      COMMON /GNC02B/ IADICT(MD,LD),
     *                IVTAB0(MVT,LVT), IVTAB1(MVT,LVT), IVTAB2(MVT,LVT),
     *                LVOID0,          LVOID1,          LVOID2,
     *                LENVCC,          INTLEN,          NDICT ,
     *                NVOID0,          NVOID1,          NVOID2
C
      CHARACTER*6 CDICT
      COMMON /GNC02C/ CDICT(LD)
C
      COMMON /GNC11A/ NC11A(60)
C
      COMMON /GNC11I/ IOLIST(10)
      COMMON /GNC11J/ JIOLST(20)
      COMMON /GNC11K/ KIOLST(20)
C
      COMMON /GNC12P/ NUMCOL,NUMROW,IPAGE
C
      COMMON /GNC12E/ KDIAG(100)
C
      COMMON /GNC12A/ NC12A(450)
      COMMON /GNC12D/ NC12D(100)
      COMMON /GNC12R/ RNC12R(50)
C
      CHARACTER*240 PNAME
      COMMON /GNC03N/ PNAME
C
      CHARACTER*60 DIRSMS, DIRDAF, DIRSAF
      COMMON /GNC12S/ DIRSMS, DIRDAF, DIRSAF
C
      CHARACTER*60 USERFN
      COMMON /GNC12U/ USERFN
C
      CHARACTER*60 UFDATA
      COMMON /GNC12F/ UFDATA
C
      INTEGER            NC14A
      COMMON /GNC14A/ NC14A(100)
      INTEGER(KIND=LONG) NC14B
      COMMON /GNC14B/ NC14B(10)
C
      INTEGER            NC17A
      COMMON /GNC17A/ NC17A(20)
      INTEGER(KIND=LONG) NC17B
      COMMON /GNC17B/ NC17B(10)
C
      COMMON /GNC16D/ NC16D(100)
C
      COMMON /TPC16T/ ITC16T(100)
      COMMON /TPC16R/ RTC16D(25)
C
      INTEGER            NC30A
      COMMON /GNC30A/ NC30A(40)
      INTEGER(KIND=LONG) NC30B
      COMMON /GNC30B/ NC30B(10)
      COMMON /GNC30R/ RNC30R(10)
C
      INTEGER            NC37A
      COMMON /GNC37A/ NC37A(10)
      INTEGER(KIND=LONG) NC37B
      COMMON /GNC37B/ NC37B(10)
      COMMON /GNC37R/ RNC37R(10)
C
      COMMON /GNC41S/ NC41S(40)
C
      COMMON /TPC41S/ ITC41S(40)
C
CNE      COMMON /GNC999/ KERR(10)
C
C---- INITIALIZE THE EXIT STATUS -------------
C
      IEXTST = 0
C
C 2002-05-16 -- BCW
C     !  FLAG FOR MAXRATIO EXCEEDED 
      IMXRTW = 0
C
C---- INITIALIZE THE PARALLEL ENVIRONMENT (IF NECESSARY) -------------
C
      CALL GN09IN(IERR)
      IF (IERR.NE.0) THEN
         WRITE (*,*)
     *      ' ****** CAN NOT INITIALIZE THE PARALLEL ENVIRONMENT ******'
         STOP 6
      END IF
C

C
C***********************************************************************
C.......................................................................
C
C---- SET UP TAB, COMMENT LINE AND SLASH CHARACTERS---------------------
C
CNE      TABC = '	'
      TABC = CHAR(9)
      COMENT = '$'

      CSLASH = '/'

C     !  CARRIAGE RETURN CHARACTER FOR PC LINE ENDING DETECTION
      CHAREX(1) = CHAR(13)
C     !  CURRENTLY UNUSED
      CHAREX(2) = CHAR(0)
      CHAREX(3) = CHAR(0)
      CHAREX(4) = CHAR(0)
      CHAREX(5) = CHAR(0)
C
C---- SET UP FILE LOGICAL UNIT NUMBERS----------------------------
C     IOLIST(1) : THE TERMINAL UNIT NUMBER
C     IOLIST(2) : UNIT NUMBER FOR SEQUENTIAL UNFORMATTED FILES
C     IOLIST(3) : THE INPUT FILE UNIT NUMBER
C     IOLIST(4) : THE OUTPUT FILE UNIT NUMBER
C     IOLIST(5) : UNIT NUMBER FOR SEQUENTIAL FORMATTED FILES
C     IOLIST(6) : UNIT NUMBER FOR SEQUENTIAL UNFORMATTED FILES
C     IOLIST(7) : UNIT NUMBER FOR UNFORMATTED DIRECT ACCESS FILES
C     IOLIST(8) : UNIT NUMBER FOR UNFORMATTED DIRECT ACCESS FILES
C     IOLIST(9) : UNIT NUMBER FOR UNFORMATTED DIRECT ACCESS FILES
C     IOLIST(10): UNIT NUMBER FOR UNFORMATTED DIRECT ACCESS FILES
C
      IOLIST(1)  = 0
      IOLIST(2)  = 21
      IOLIST(3)  = 9
      IOLIST(4)  = 6
      IOLIST(5)  = 8
      IOLIST(6)  = 26
      IOLIST(7)  = 27
      IOLIST(8)  = 28
      IOLIST(9)  = 29
      IOLIST(10) = 23
C
C---- SET UP FILE LOGICAL UNIT NUMBERS FOR THE SOLVER AND DATA MANAGER.
C     JIOLST(1) : DIRECT ACCESS FILE "K" FOR THE STIFFNESS MATRIX.
C     JIOLST(2) : DIRECT ACCESS FILE "F" FOR THE LOAD AND DISPLACEMENTS.
C     JIOLST(3) : DIRECT ACCESS FILE "KH" FOR THE HEAT TRANSFER'S
C                 CONDUCTIVITY MATRIX.
C     JIOLST(4) : DIRECT ACCESS FILE "SNS" FOR THE PSEUDO LOAD AND
C                 DISPLACEMENT DERIVATIVES.
C     JIOLST(5) : THE STARTING LOGICAL UNIT NUMBER FOR THE DATABASE.
C                 JIOLST(5) TO JIOLST(5)+9 ARE THE LOGICAL UNIT NUMBERS
C                 THAT MAY BE USED FOR DATABASES IN THE DATA MANAGER.
C                 NOTE: WHEN DATA MANAGER SPILLS DATABASES WILL BE
C                       CREATED ONLY IF THIS NUMBER IS GREATER THAN 0.
C                       IF JIOLST(5) = 0, THEN EACH DATA BLOCKS WILL BE
C                       SAVED AS A DIRECT ACCESS FILE WHEN SPILLS.
C                       IF JIOLST(5) < 0, THEN EACH DATA BLOCKS WILL BE
C                       SAVED AS A SEQUENTIAL ACCESS FILE WHEN SPILLS.
C     JIOLST(6) : SEQUENTIAL UNFORMATTED FILES "SPK", "SPM", AND "SPH"
C                 FOR THE SPARSE STIFFNESS, MASS, AND CONDUCTIVITY
C                 MATRICES.
C     JIOLST(7) : JIOLST(7) TO JIOLST(7)+6 ARE THE UNIT NUMBERS TO
C                 BE USED IN THE SPARSE MATRIX PACKAGE.
C     JIOLST(8) : JIOLST(8)+1 TO JIOLST(8)+4 ARE THE UNIT NUMBERS
C                 TO BE USED IN THE LANCZOS EIGEN SOLVER.
C     JIOLST(9) : DIRECT ACCESS FILE "FH" FOR THE HEAT AND TEMPERATURE
C                 VECTORS.
C     JIOLST(10): DIRECT ACCESS FILE "KDD" FOR THE DIRECT DYNAMIC
C                 ANALYSIS' GLOBAL COMPLEX MATRIX.
C     JIOLST(11): DIRECT ACCESS FILE "KDM" FOR THE MODAL DYNAMIC
C                 ANALYSIS' REDUCED MODAL COMPLEX MATRIX.
C     JIOLST(12): DIRECT ACCESS FILE "FD" FOR THE DYNAMIC LOADS AND
C                 THE VIBRATION AMPLITUDE VECTORS (COMPLEX).
C     JIOLST(13): DIRECT ACCESS FILE "FM" FOR THE MODAL DYNAMIC LOADS
C                 AND THE VIBRATION AMPLITUDE VECTORS (REDUCED).
C     JIOLST(14): DIRECT ACCESS FILE "SNZ" FOR THE COMPLEX PSEUDO LOAD
C                 AND COMPLEX DISPLACEMENT DERIVATIVES.
C     JIOLST(15): NOT CURRENTLY USED.
C     JIOLST(16): DIRECT ACCESS FILE "PSI" FOR THE PSI VECTOR IN
C                 CALCULATING THE EIGENVECTOR DERIVATIVES.
C     JIOLST(17): DIRECT ACCESS FILE "PSC" FOR THE LAGRANGE PART OF THE
C                 PSI VECTOR IN CALCULATING THE EIGENVECTOR DERIVATIVES.
C     JIOLST(18): UNIT NUMBER FOR  FOR SEQUENTIAL FORMATTED FILE "SHP"
C     JIOLST(19): UNIT NUMBER FOR UNFORMATTED DIRECT ACCESS FILES
C     JIOLST(20): UNIT NUMBER FOR  FOR SEQUENTIAL FORMATTED FILE "DVG"
C NOTE: 1. JIOLST(1) AND JIOLST(3) ARE USED ONLY FOR THE BLOCK SKYLINE
C          SOLVER.
C       2. JIOLST(7) AND JIOLST(8) ARE USED ONLY FOR THE SPARSE MATRIX 
C          SOLVER.
C
      JIOLST(1)  = 15
      JIOLST(2)  = 16
      JIOLST(3)  = 17
      JIOLST(4)  = 18
C     !  THE FOLLOWING LINE RESERVES UNITS 90-99
      JIOLST(5)  = 90
      JIOLST(6)  = 22
C     !  THE FOLLOWING LINE RESERVES UNITS 31-37
      JIOLST(7)  = 31
C     !  THE FOLLOWING LINE RESERVES UNITS 62-65
      JIOLST(8)  = 61
      JIOLST(9)  = 19
      JIOLST(10) = 10
      JIOLST(11) = 11
      JIOLST(12) = 12
      JIOLST(13) = 13
      JIOLST(14) = 14
      JIOLST(15) = 41
      JIOLST(16) = 51
      JIOLST(17) = 52
      JIOLST(18) = 53
      JIOLST(19) = 30
      JIOLST(20) = 54
C
C 09/05/96 -- BCW
C---- SET UP FILE LOGICAL UNIT NUMBERS FOR THE SOLVER AND DATA MANAGER.
C     KIOLST(1): UNIT NO. FOR UNFORMATTED DIRECT ACCESS FILE "A" FOR
C                ASET REDUCED BASIS VECTORS
C     KIOLST(2): UNIT NO. FOR UNFORMATTED DIRECT ACCESS FILE "AC" FOR
C                CONSTRAINT PORTION OF ASET REDUCED BASIS VECTORS
C     KIOLST(3): UNIT NO. FOR UNFORMATTED DIRECT ACCESS FILE "RK" FOR
C                REDUCED STIFFNESS AND MASS MATRICES
C     KIOLST(4): UNIT NO. FOR UNFORMATTED DIRECT ACCESS FILE "SA" FOR
C                ASET REDUCED BASIS VECTOR SENSITIVITIES
C     KIOLST(5): UNIT NO. FOR UNFORMATTED DIRECT ACCESS FILE "SAC" FOR
C                CONSTRAINT PORTION OF ASET REDUCED BASIS VECTORS
C                SENSITIVITIES
C     KIOLST(6): UNIT NO. FOR UNFORMATTED DIRECT ACCESS FILE "SRK" FOR
C                REDUCED STIFFNESS AND MASS SENSITIVITIES
C 11/19/96 -- JPL
C     KIOLST(7): UNIT NO. FOR UNFORMATTED DIRECT ACCESS FILE "SKA" FOR
C                SENSITIVITIES OF REDUCED STIFFNESS WITH RESPECT TO
C                USER INDEPENDENT DESING VARIABLES 
C     KIOLST(8): UNIT NO. FOR UNFORMATTED DIRECT ACCESS FILE "SMA" FOR
C                SENSITIVITIES OF REDUCED STIFFNESS WITH RESPECT TO
C                USER INDEPENDENT DESING VARIABLES 
C     KIOLST(9): UNIT NO. FOR UNFORMATTED DIRECT ACCESS FILE "XXYY.SKA"
C                AND XXYY.SMA" FOR SENSITIVITIES OF REDUCED STIFFNESS
C                WITH RESPECT TO USER INDEPENDENT DESING VARIABLES 
C     KIOLST(10):UNIT NO. FOR USER FILE IN GNMASS 
C     KIOLST(11):UNIT NO. FOR UNFORMATTED DIRECT ACCESS FILE "QMA" FOR
C                QSET-ASET MASS COUPLING MATRICES
C
      KIOLST(1)  = 55
      KIOLST(2)  = 56
      KIOLST(3)  = 57
      KIOLST(4)  = 58
      KIOLST(5)  = 59
      KIOLST(6)  = 60
      KIOLST(7)  = 71
      KIOLST(8)  = 72
      KIOLST(9)  = 73
      KIOLST(10) = 74
      KIOLST(11) = 75
C
C 07/16/97
C---- SET THE DEFAULT MEMORY USE--------------------
C


C
C     !  set the environment variable name
C

      LENENV = 'GENESIS_LENVEC'

C
C     !  machine dependent call to get environment variable value
C

      LLENNV = LEN_TRIM(LENENV)
      CALL PXFGETENV(LENENV, LLENNV, CLENVC, LCLNVC, IERR)
      IF(IERR.NE.0) CLENVC=' '

C
      IF(CLENVC.EQ.' ') THEN
C

C        !  set a hardcoded default value for LENVEC
C
         LENVEC=LENVC

C
      ELSE
C
         READ(CLENVC,'(I20)',IOSTAT=IERR,ERR=999) LENVEC
 999     CONTINUE
         IF(IERR.NE.0 .OR. LENVEC.LE.0) LENVEC=LENVC
C
      ENDIF


C
      IVERN1=9
      IVERN2=0
C
      IDATE1=0
      IDATE2=0
      IDATE3=0
      ITIME1=0
      ITIME2=0
C
      CALL GN00DT(IDATE1,IDATE2,IDATE3,ITIME1,ITIME2)
C
      IPAGE=0
      NUMROW=NMROW
      NUMCOL=NMCOL
      INTLEN=INTLN
      LEQMX=LEQMAX
      LINE=' '
C
C     GET SYSTEM INFO
C
      CALL GN00SY(1)
C
C***********************************************************************
C.......................................................................
C
C-----OPEN INPUT DATA AND OUTPUT FILES -------------------------------
C
C     ***** INTERACTIVE MODE *****
C
C     WRITE(6,*) ' WHAT IS THE INPUT DATA FILE NAME?'
C     READ(5,'(A20)') FLNAME
C
C        NIN = IOLIST(3)
C        CALL GN03IN(NIN,FLNAME,IERR)
C        IF (IERR.NE.0) STOP 9
C 
C --- OPTION 1 - OUTPUT TO A UNIT NUMBER
C
C        WRITE(6,*) ' WHAT IS THE OUTPUT UNIT NUMBER?'
C        READ(5,*) NOT
C        IOLIST(4) = NOT
C
C --- OPTION 2 - OUTPUT TO A FILE WITH THE SAME FILE NAME AS THE INPUT
C                FILE BUT WITH A DIFFERENT EXTENSION
C
C        NOT = IOLIST(4)
C        CALL GN03OU(NOT,FLNAME,IERR)
C
C......................................................................
C**********************************************************************
C
C***********************************************************************
C.......................................................................
C
C-----OPEN INPUT DATA AND OUTPUT FILES -------------------------------
C
C     ***** BATCH MODE *****
C
C --- OPTION 1 - READ INPUT FROM STANDARD INPUT UNIT ( UNIT 5 )
C                OUTPUT TO STANDARD OUTPUT UNIT ( UNIT 6 )
C
C        NIN = 5
C        IOLIST(3) = NIN
C
C --- OPTION 2 - READ FROM FILE NAME PASSED FROM OPERATING
C                SYSTEM OUTPUT TO FILE WITH SAME NAME BUT DIFFERENT
C                EXTENSION
C                IF NO NAME WAS PASSED FROM OS, THEN USE STANDARD
C                INPUT AND OUTPUT (UNITS 5 & 6 RESPECTIVELY)


C --- *** FOR CRAY, OTHER POSIX SYSTEMS
C
         NARG = IPXFARGC()
         IF (NARG.GE.1) THEN
            CALL PXFGETARG(1,FLNAME,LFLNAM,IERP)
            NIN = IOLIST(3)
            NOT = IOLIST(4)
            CALL GN03IN(NIN,FLNAME,IERR)
            CALL GN03OU(NOT,FLNAME,IERR)
         ELSE
            NIN = 5
            IOLIST(3) = NIN
         ENDIF
C


C
C --- OPTION 3 - READ FROM STANDARD INPUT FILENAME
C                OUTPUT TO STANDARD OUTPUT UNIT ( UNIT 6 )
C

C        NIN = IOLIST(3)
C        FLNAME = 'test.dat'
C        CALL GN03IN(NIN,FLNAME,IERR)
C        IF (IERR.NE.0) STOP 9

C
C --- OPTION 4 - COPY INPUT FILE FROM STANDARD INPUT UNIT 0 TO A
C                SCRATCH FILE AND READ FROM THIS SCRATCH FILE
C                OUTPUT TO STANDARD OUTPUT UNIT ( UNIT 6 )
C
C        NIN = IOLIST(3)
C        OPEN(NIN,STATUS='SCRATCH')
C8000    CONTINUE
C        READ(0,'(A)',END=8010) LINE
C        WRITE(NIN,'(A)') LINE
C        GOTO 8000
C8010    CONTINUE
C        REWIND NIN
C
C......................................................................
C**********************************************************************
C
C     CALL MAIN PROGRAM DRIVER
C
      CALL GN0000(LENVEC,ESTRNG,LEQMX)
C
 9999 CONTINUE
C

C
C---- FINALIZE THE PARALLEL ENVIRONMENT (IF NECESSARY) -----------------
C
      CALL GN09FN(IERR)
C
C---- EXIT WITH EXIT STATUS -------------
C
      CALL EXIT( IEXTST )
C
      END
C

C============================================================== GN00IG
C
      INTEGER FUNCTION JN00IG()

      JN00IG = 1

      RETURN
      END
C============================================================== GN00DT
C
      SUBROUTINE GN00DT(IDATE1,IDATE2,IDATE3,ITIME1,ITIME2)
C
C     THIS SUBROUTINE GETS THE SYSTEM'S DATE AND TIME.
C     IDATE1 = MONTH
C     IDATE2 = DAY
C     IDATE3 = YEAR
C     ITIME1 = HOUR
C     ITIME2 = MINUTE
C

C     ----- FORTRAN 90 STANDARD VERSION -----
C
      CHARACTER*10 CBUFF
      CALL DATE_AND_TIME(DATE=CBUFF)
      READ(CBUFF(5:6),'(I2)',IOSTAT=IE1) IDATE1
      READ(CBUFF(7:8),'(I2)',IOSTAT=IE1) IDATE2
      READ(CBUFF(1:4),'(I4)',IOSTAT=IE1) IDATE3
      CALL DATE_AND_TIME(TIME=CBUFF)
      READ(CBUFF(1:2),'(I2)',IOSTAT=IE1) ITIME1
      READ(CBUFF(3:4),'(I2)',IOSTAT=IE1) ITIME2
C
C

C
      RETURN
      END
C=======================================================================
C
      SUBROUTINE GN02MD (NUMINT)
C
C     SET THE NUMBER OF INTEGERS THAT HAVE THE EQUIVALENT AMOUNT OF
C     STORAGE AS A (DOUBLE PRECISION) REAL NUMBER
C

C --- FOR SUN, SGI, VAX/VMS, IBM, FUJITSU, HITACHI, CONVEX, HP, DEC,
C     RS6, PC, ETC.
C
      NUMINT = 2

C
      RETURN
      END
C=======================================================================
C
      SUBROUTINE GN02BD (IDBLSZ)
C
C     SET THE NUMBER OF BYTES IN A REAL DOUBLE PRECISION NUMBER
C
      IDBLSZ = 8
C
      RETURN
      END
C=======================================================================
C
      SUBROUTINE GN02SZ (ILIMIT,MXDBRC)
C
C     SET THE INDEX FOR THE DIRECT ACCESS FILE SIZE EXPANDABILITY AND
C     THE STARTING NUMBER OF RECORDS FOR THE DATA BASE FILES.
C

C
      ILIMIT = 0
      MXDBRC = 100
C

C
      RETURN
      END
C=======================================================================
C
      SUBROUTINE GN03DF (IDLFIL)
C
C     SET THE INDEX FOR THE TREATMENT OF THE EXISTING SCRATCH FILES.
C     IDLFIL =  2 : TO DELETE THE EXISTING SCRATCH FILES AND GIVE
C                   INFORMATION ON THE DELETED FILES.
C     IDLFIL =  1 : TO DELETE THE EXISTING SCRATCH FILES WITHOUT
C                   INFORMATION ON THE DELETED FILES.
C     IDLFIL =  0 : TO GIVE ERROR MESSAGES FOR THE EXISTING SCRATCH
C                   FILES.
C     IDLFIL = -1 : DO NOT CHECK THE EXISTENCE OF THE SCRATCH FILES.
C

C
      IDLFIL = 2
C

C
      RETURN
      END
C=======================================================================
C
      SUBROUTINE GN03MD (NI, NR, LRECL)
C
C     CALCULATE THE RECORD LENGTH REQUIRED FOR STORING NI INTEGERS
C     AND NR REAL (DOUBLE PRECISION) NUMBERS IN AN UNFORMATTED DIRECT
C     ACCESS FILE.
C


C --- FOR SUN, IBM, FUJITSU, HITACHI, CONVEX, ETC.
C
C     RECORD LENGTH IS IN BYTES.  INTEGERS ARE 4 BYTES AND REAL (DOUBLE 
C     PRECISION) NUMBERS ARE 8 BYTES.
C
      PARAMETER (NIBYTE=4, NRBYTE=8)
C
      LRECL = NI * NIBYTE + NR * NRBYTE
C


C
      RETURN
      END
C=======================================================================
C
      SUBROUTINE GN03PP (FN, MFN, LMFN)
C
C     MODIFY A FILENAME BASED ON EXTENSION AND ENVIRONMENT VARIABLES
C

      CHARACTER*(*) FN
      CHARACTER*(*) MFN
      INTEGER LMFN
C
      CHARACTER*1 TABC,COMENT,CSLASH,CHAREX(5)
      COMMON /GNC00C/ TABC,COMENT,CSLASH,CHAREX
C
      CHARACTER*16   ENVNAM
      CHARACTER*260  ENVVAL
C

C
C     !  Get the filename extension
C
      ISLASH=0
      IDOT=0
      IEND=0
      DO I=LEN(FN),1,-1
         IF(FN(I:I).NE.' ' .AND. IEND.EQ.0) IEND=I
         IF(FN(I:I).EQ.CSLASH .AND. ISLASH.EQ.0 .AND.
     *      I.LT.IEND) ISLASH=I
         IF(FN(I:I).EQ.'.' .AND. IDOT.EQ.0) IDOT=I
         IF(IEND.NE.0 .AND. IDOT.NE.0 .AND. ISLASH.NE.0) GO TO 1000
      END DO
 1000 CONTINUE
      I0 = 1
      IF(ISLASH.GT.0) I0=ISLASH+1
      I1 = 1
      IF(IDOT.GT.0) I1=IDOT+1
      I2 = IEND
C
      IF (I2.LT.I1) THEN
         MFN = FN
         LMFN = LEN(FN)
         IF (LMFN.GT.LEN(MFN)) LMFN = LEN(MFN)
      ENDIF
C
C     !  Check environment variable named VRAND_SDIR_ext
C
      ENVNAM = 'VRAND_SDIR_'//FN(I1:I2)

C
      LENVNM = LEN_TRIM(ENVNAM)
      CALL PXFGETENV(ENVNAM, LENVNM, ENVVAL, LENVVL, IER1)
      IF(IER1.NE.0) THEN
         ENVVAL=' '
         LENVVL=0
      ENDIF
C

      IF (LENVVL.LE.0) THEN
C
C        !  environment variable not set -- don't change filename
C
         MFN = FN
         LMFN = LEN(FN)
         IF (LMFN.GT.LEN(MFN)) LMFN = LEN(MFN)
C
      ELSE
C
C        !  environment variable set -- replace path with value
C
         MFN = ENVVAL
         IF (LENVVL+1 + I2-I0+1 .GT. LEN(MFN)) THEN
            LENVVL = LEN(MFN) - (I2-I0+1) - 1
         ENDIF
         IF (MFN(LENVVL:LENVVL).NE.CSLASH) THEN
            LENVVL=LENVVL+1
            MFN(LENVVL:LENVVL) = CSLASH
         ENDIF
         MFN(LENVVL+1:) = FN(I0:I2)
         LMFN = LENVVL + I2-I0+1
C
      ENDIF
C
      RETURN
      END
C=======================================================================
C
      SUBROUTINE GN03OP (LUN, FN, FSTAT, LENR, NREC, IERR)
C
C     OPEN DIRECT ACCESS UNFORMATTED FILES.
C
      CHARACTER*(*) FN, FSTAT
C

C
C     STANDARD F77 OPEN STATEMENT.
C
      IF (FSTAT(1:3).EQ.'NEW') THEN
C
C ===    OPEN A NEW FILE
C
         OPEN (LUN, FILE=FN, STATUS='NEW', FORM='UNFORMATTED',
     *         ACCESS='DIRECT', RECL=LENR, IOSTAT=IERR, ERR=999)
C
      ELSE
C
C ===    OPEN AN OLD FILE
C
         OPEN (LUN, FILE=FN, STATUS='OLD', FORM='UNFORMATTED',
     *         ACCESS='DIRECT', RECL=LENR, IOSTAT=IERR, ERR=999)
C
      END IF

C
 999  RETURN
      END
C=======================================================================
C
      SUBROUTINE GN03SF (LUN, FN, FSTAT, FILEFM, IERR)
C
C     OPEN SEQUENTIAL ACCESS FILES.
C     FILE FORMAT MAY BE: FORMATTED, UNFORMATTED, OR PUNCH FILE.
C
      CHARACTER*(*) FN,FSTAT,FILEFM
C

C
C     STANDARD F77 OPEN STATEMENT.
C
      IF (FILEFM(1:5).EQ.'PUNCH') THEN
         OPEN (LUN, FILE=FN, STATUS=FSTAT, FORM='FORMATTED',
     *         IOSTAT=IERR, ERR=999)
      ELSE
         OPEN (LUN, FILE=FN, STATUS=FSTAT, FORM=FILEFM,
     *         IOSTAT=IERR, ERR=999)
      END IF
C


 999  RETURN
      END
C=======================================================================
C
      SUBROUTINE GN03AP (LUN, FN, FILEFM, IERR)
C
C     OPEN A FORMATTED SEQUENTIAL ACCESS FILE FOR APPEND.
C     FILE FORMAT MAY BE: FORMATTED OR PUNCH.
C
      CHARACTER*(*) FN,FILEFM
C

C
C     STANDARD F90 OPEN STATEMENT.
C
      OPEN (LUN, FILE=FN, STATUS='OLD', FORM='FORMATTED',
     *      ACCESS='SEQUENTIAL', POSITION='APPEND',
     *      IOSTAT=IERR, ERR=999)
C

 999  RETURN
      END
C=======================================================================
C
      SUBROUTINE GN14MD (MAXLEN, IDEAL)
C
C     SET THE MAXIMUM RECORD LENGTH AND A RECORD LENGTH THAT CONTAINS
C     16K REAL (DOUBLE PRECISION) NUMBERS IN AN UNFORMATTED DIRECT
C     ACCESS FILE.  THE SECOND RECORD LENGTH IS CALLED THE "IDEAL"
C     RECORD LENGTH.
C

C
C     RECORD LENGTH IS IN BYTES.
C
      MAXLEN = 1048576
      IDEAL  = 131072
C

C
      RETURN
      END
C=======================================================================
C
      SUBROUTINE GN12QS (ISOL)
C
C     RETURNS THE DEFAULT FOR EXECUTIVE CONTROL SOL.
C

      CHARACTER*11  SOLENV
      CHARACTER*20  SOLVAL
C

      SOLENV = 'GENESIS_SOL'

C

C
      LSOLNV = LEN_TRIM(SOLENV)
      CALL PXFGETENV(SOLENV, LSOLNV, SOLVAL, LSOLVL, IER1)
      IF(IER1.NE.0) SOLVAL=' '
C

C
      IF (SOLVAL .EQ. ' ') THEN

         ISOL = 0

      ELSE IF (SOLVAL .EQ. 'COMPAT0' .OR. SOLVAL .EQ. '0') THEN
         ISOL = 0
      ELSE
         ISOL = 1
      ENDIF
C
      RETURN
      END
C=======================================================================
C
      SUBROUTINE GN12PN (OPNAME,PREFIX)
C
C     RETURNS THE PROJECT NAME AND PREFIX PASSED IN FROM THE OPERATING
C     SYSTEM.
C

C
      CHARACTER*240 PNAME
      COMMON /GNC03N/ PNAME
C
      CHARACTER*(*) OPNAME,PREFIX
C
      CHARACTER*1 TABC,COMENT,CSLASH,CHAREX(5)
C
      COMMON /GNC00C/ TABC,COMENT,CSLASH,CHAREX
C

C --- *** FOR CRAY  (AND OTHER POSIX SYSTEMS)
C
      CHARACTER*256 ARG1
C
      NARG = IPXFARGC()
      IF (NARG.GE.1) THEN
         KARG = 1
         IF (NARG.GE.2) KARG = 2
         CALL PXFGETARG(KARG,ARG1,LPNAM,IERP)
         ISLASH=0
         IDOT=0
         IEND=0
         DO I=LPNAM,1,-1
            IF(ARG1(I:I).NE.' ' .AND. IEND.EQ.0) IEND=I
            IF(ARG1(I:I).EQ.CSLASH .AND. ISLASH.EQ.0 .AND.
     *         I.LT.IEND) ISLASH=I
            IF(ARG1(I:I).EQ.'.' .AND. IDOT.EQ.0) IDOT=I
            IF(IEND.NE.0 .AND. IDOT.NE.0 .AND. ISLASH.NE.0) GO TO 1000
         END DO
 1000    CONTINUE
         I1 = 1
         IF(ISLASH.GT.0) I1=ISLASH+1
         I2 = IEND
         IF(KARG.EQ.1 .AND. IDOT.GT.I1) I2 = IDOT-1
         PNAME = ARG1(I1:I2)
      ELSE
         PNAME = 'pname'
      ENDIF
      PREFIX = ' '
C

C
      OPNAME = PNAME
      CALL GN09PN(PNAME)
C
      RETURN
      END
C=======================================================================
C
      SUBROUTINE GN12PL (PNAME,IPOST)
C
C     REDUCE THE PROJECT NAME LENGTH
C
      CHARACTER*(*) PNAME
C
      INTEGER IPOST
C
C     DO NOT DO ANYTHING
C
      RETURN
      END
C=======================================================================
C
      SUBROUTINE GN00SY(IFLAG)
C
C     GET OR PRINT SYSTEM INFO.
C

C
      USE GNKIND
      USE GN02
C
      COMMON /GNC11I/ IOLIST(10)
C
      CHARACTER*240 PNAME
      COMMON /GNC03N/ PNAME
C
      COMMON /GNC00V/ IVERN1,IVERN2,IDATE1,IDATE2,IDATE3,ITIME1,ITIME2
C
      INTEGER(KIND=LONG) LENVEC
C
      CHARACTER*40 UNAME
      SAVE UNAME
C

      CHARACTER*10 SNAME,RNAME,VNAME,MNAME

C
      CHARACTER*3 MNTH(12)
      DATA MNTH /'Jan','Feb','Mar','Apr','May','Jun',
     *           'Jul','Aug','Sep','Oct','Nov','Dec'/
C
      IF (IFLAG.NE.0) THEN
         UNAME = ' '

         CALL PXFSTRUCTCREATE('utsname',JUNAME, IE1)
         IF (IE1.NE.0) RETURN
         CALL PXFUNAME(JUNAME, IE1)
         IF (IE1.EQ.0) THEN
            CALL PXFSTRGET(JUNAME,'sysname',SNAME,LN,IE1)
            CALL PXFSTRGET(JUNAME,'release',RNAME,LN,IE1)
            CALL PXFSTRGET(JUNAME,'version',VNAME,LN,IE1)
            CALL PXFSTRGET(JUNAME,'machine',MNAME,LN,IE1)
            UNAME = TRIM(SNAME)//' '//TRIM(RNAME)//' '//
     *              TRIM(VNAME)//' '//TRIM(MNAME)
         ENDIF
         CALL PXFSTRUCTFREE(JUNAME, IE1)

      ELSE IF (PNAME.NE.' ') THEN
         NOT = IOLIST(4)
         WRITE (NOT,500) TRIM(PNAME),
     *                   MNTH(IDATE1),IDATE2,IDATE3,ITIME1,ITIME2,

     $                   'Cray'


     $                   ,TRIM(UNAME)


     $                   //' (LP64)'

         CALL GN02LV(LENVEC)
         WRITE (NOT,510) LENVEC
      ENDIF
C
 500  FORMAT (/
     *5X,'PROJECT NAME: ',A/
     *5X,'RUN STARTED:  ',A,1X,I2,', ',I4,1X,I2.2,':',I2.2/
     *5X,'SYSTEM TYPE:  ',A,1X,A)
 510  FORMAT (
     *5X,'LENVEC:       ',I15/)

      RETURN
      END
C=======================================================================
C
      SUBROUTINE GN00TM (CPUTIM)
C
C     RETURNS THE TOTAL CPU SECONDS SPENT UP TO TIME THIS SUBROUTINE
C     IS CALLED.
C

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C

C --- Standard Fortran 95
C
      CALL CPU_TIME(CPUTIM)
C

C
      RETURN
      END
C=======================================================================
C
      SUBROUTINE GN00CT (EWCTIM)
C
C     RETURNS THE ELAPSE WALL CLOCK TIME IN SECONDS MEASSURED STARTING
C     FROM THE EXCUTION START OR THIS SUBROUTINE IS FIRST CALLED.
C

      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C

C --- Standard Fortran 90
C
      INTEGER NOW
      INTEGER NOWM
      INTEGER, SAVE :: LAST = -1
      INTEGER, SAVE :: LASTM = -1
      INTEGER VALUES(8)
C
      DOUBLE PRECISION, SAVE :: ESUM
C
      CALL DATE_AND_TIME(VALUES=VALUES)
      IF (LAST.LT.0) THEN
         IF (VALUES(5) .GE. 0) THEN
            LAST = 3600*VALUES(5) + 60*VALUES(6) + VALUES(7)
            LASTM = 512*VALUES(1) + 32*VALUES(2) + VALUES(3)
         ENDIF
         ESUM = 0.0D0
      ELSE
         NOW = 3600*VALUES(5) + 60*VALUES(6) + VALUES(7)
         NOWM = 512*VALUES(1) + 32*VALUES(2) + VALUES(3)
         IF (NOWM .NE. LASTM) THEN
C           !  We assume that the count has only rolled over
C           !  once since the last call.
            ESUM = ESUM + 86400.0
         ENDIF
         ESUM = ESUM + (NOW-LAST)
         LAST = NOW
         LASTM = NOWM
      ENDIF
C
      EWCTIM = ESUM
C

C
      RETURN
      END
C=======================================================================
C
      SUBROUTINE GN00AU(IERR)
C
C     PRINT A MESSAGE IF NO AUTHORIZATION FILE WAS FOUND
C

      CHARACTER*10  AUTENV
      CHARACTER*260 AUTFIL
C
      INTEGER IOLIST
      COMMON /GNC11I/ IOLIST(10)
      INTEGER NOT, NTM

      CHARACTER*1 TABC,COMENT,CSLASH,CHAREX(5)
      COMMON /GNC00C/ TABC,COMENT,CSLASH,CHAREX
C

C
      NTM = IOLIST(1)
      NOT = IOLIST(4)

      IF (IERR.NE.0) THEN
C
         AUTENV = 'VRAND_PATH'

C
         LAUTNV = LEN_TRIM(AUTENV)
         CALL PXFGETENV(AUTENV, LAUTNV, AUTFIL, LAUTFL, IER1)
         IF(IER1.NE.0) AUTFIL=' '
C

C
         LAUTFL = LEN_TRIM(AUTFIL)
         IF (LAUTFL.GT.0) THEN
            AUTFIL = AUTFIL(1:LAUTFL)//CSLASH//'licenses'//CSLASH//

     $               'genesis.lic'

            LAUTFL = LEN_TRIM(AUTFIL)
         ENDIF

         WRITE (NOT,3101)
         IF(LAUTFL.EQ.0) THEN
            WRITE (NOT,3111)
         ELSE
            WRITE (NOT,3121) AUTFIL(1:MAX(47,LAUTFL))
         ENDIF
         WRITE (NOT,3105)

         WRITE (NOT,3104)

         WRITE (NOT,3102)

         WRITE (NTM,4101)
      ENDIF
 3101 FORMAT(
     *6X,'*******************************************************'/
     *6X,'*******************************************************'/
     *6X,'***                                                 ***'/
     *6X,'***    N O   A U T H O R I Z A T I O N   D A T A    ***'/
     *6X,'***                                                 ***' )
 3111 FORMAT(
     *6X,'***         SET THE ENVIRONMENT VARIABLE:           ***'/
     *6X,'***                 ''VRAND_PATH''                    ***'/
     *6X,'***          TO THE FULL PATH NAME OF THE           ***'/
     *6X,'***             INSTALLATION DIRECTORY              ***'/
     *6X,'***                                                 ***' )
 3121 FORMAT(
     *6X,'*** IF YOU HAVE RECIEVED AN AUTHORIZATION FILE,     ***'/
     *6X,'*** COPY IT TO THE FILE NAMED:                      ***'/
     *6X,'*** ',A,' ***'/
     *6X,'***                                                 ***' )
 3105 FORMAT(
     *6X,'*******************************************************'/
     *6X,'***                                                 ***'/
     *6X,'***                  CONTACT VR&D                   ***'/
     *6X,'***       FOR INFORMATION ON HOW TO OBTAIN A        ***'/
     *6X,'***                 LICENSE TO RUN                  ***'/
     *6X,'***                                                 ***'/

     *6X,'***                 G E N E S I S                   ***'/
     *6X,'***                                                 ***'/
     *6X,'***  STRUCTURAL ANALYSIS AND OPTIMIZATION SOFTWARE  ***'/

     *6X,'***                                                 ***'/
     *6X,'***         PHONE: (719) 473-4611                   ***'/
     *6X,'***         FAX:   (719) 473-4638                   ***'/
     *6X,'***         EMAIL: sales@vrand.com                  ***'/
     *6X,'***         WEB:   http://www.vrand.com             ***'/
     *6X,'***                                                 ***' )

 3104 FORMAT(
     *6X,'*******************************************************'/
     *6X,'***                                                 ***'/
     *6X,'***    THE FULLY LICENSED GENESIS HAS NO FIXED      ***'/
     *6X,'***    PROBLEM SIZE LIMITS!  GENESIS HAS SOLVED     ***'/
     *6X,'***    PROBLEMS WITH:                               ***'/
     *6X,'***                                                 ***'/
     *6X,'***     1,000,000+ DEGREES OF FREEDOM               ***'/
     *6X,'***     1,000,000+ CONSTRAINTS                      ***'/
     *6X,'***         2,000+ SHAPE/SIZING DESIGN VARIABLES    ***'/
     *6X,'***                                                 ***' )


 3102 FORMAT(
     *6X,'*******************************************************'/
     *6X,'***                                                 ***'/
     *6X,'***    GENESIS WILL RUN IN DEMONSTRATION MODE.      ***'/
     *6X,'***                                                 ***'/
     *6X,'***    DEMONSTRATION PROBLEMS LIMITED TO:           ***'/
     *6X,'***                                                 ***'/
     *6X,'***         200 GRIDS                               ***'/
     *6X,'***           5 SHAPE/SIZING DESIGN VARIABLES       ***'/
     *6X,'***        1000 CONSTRAINTS                         ***'/
     *6X,'***                                                 ***'/
     *6X,'*******************************************************'/
     *6X,'*******************************************************'/)


 4101 FORMAT('*** GENESIS RUNNING IN DEMO MODE ***')

      RETURN
      END
C=======================================================================
C
      SUBROUTINE GN02AL(IARRAY, IUNIT, NUM, MOFFST, IERR)
      USE GNKIND
C
      INTEGER            IUNIT , IERR
C
      INTEGER(KIND=LONG) NUM   , MOFFST
C
      INTEGER            IARRAY(*)
C
C     DYNAMICALLY ALLOCATES THE STORAGE VECTOR
C
      INTEGER            JARRAY(1), IDUMMY(1)
      POINTER (IA, IDUMMY)
      POINTER (JA, JARRAY)
      INTEGER(KIND=LONG) M
      INTEGER(KIND=LONG) LIUNIT
      INTEGER(KIND=LONG) :: LENLNG
      INTEGER            :: LENDEF


C     !  Don't declare MALLOC


C


C --- *** FOR SUN, HP, SGI, PC
C
      IA = LOC(IARRAY)
      LIUNIT = IUNIT
      LENLNG = (NUM+1) * LIUNIT

      JA = MALLOC(LENLNG)

C
      IF(JA .NE. 0) THEN
         IF(JA.GT.IA) THEN
            M = JA-IA
            M = MOD(M,LIUNIT)
            IF (M.LT.0) M = M + LIUNIT
            MOFFST = (JA-IA + LIUNIT - M)/LIUNIT
         ELSE
            M = IA-JA
            M = MOD(M,LIUNIT)
            IF (M.LT.0) M = M + LIUNIT
            MOFFST = (JA-IA + M)/LIUNIT
         ENDIF
         IERR = 0
      ELSE
         IERR = 1
      ENDIF


C
      RETURN
      END
C=======================================================================
C
      SUBROUTINE GN02VC(LENVEC, LNVCIN, ILVFLG)
C
      USE GNKIND
      USE GN02
C
      INTEGER(KIND=LONG) LENVEC, LNVCIN
      INTEGER            ILVFLG
C

C --- *** FOR SUN, HP, RS6000, SGI, PC
C
      IF(ILVFLG.EQ.1) THEN
         LENVEC = LNVCIN
      ENDIF
C

      RETURN
      END
C=======================================================================
C
      SUBROUTINE GN00EX
C
C     EXIT WITH ERROR EXIT STATUS (SYSTEM OR PROGRAMMING ERROR)
C
      CALL GN99AL(1)
C
      CALL EXIT( 1 )
C
      STOP
C
      END
C=======================================================================
C
      SUBROUTINE GN02SW(CMND)
C
C     CALL AN EXTERNAL PROGRAM
C

      CHARACTER*(*) CMND
      CALL PXFSYSTEM(CMND, 0, IER1)

      END
C=======================================================================
C
      SUBROUTINE GN99AL(IERR)
C
C     ALERTS THE USER TO ERRORS IN THE RUN
C

C --- *** FOR SUN, HP, RS6000, SGI, CRAY, DEC
C
      COMMON /GNC00E/ IEXTST, IMXRTW
C
      COMMON /GNC11I/ IOLIST(10)
      NTM = IOLIST(1)
C
      IF (IERR .GT. 0) IEXTST = 1
C
C     !  2002-05-16 -- BCW
      IF (IMXRTW .NE. 0) THEN
         WRITE(NTM,*)
     *' WARNING - Stiffness matrix is nearly singular.'
         WRITE(NTM,*) 
     *'           Check warning message code 320203 in the output file.'
      ENDIF
C
      IF (IERR.EQ.1) THEN
         WRITE(NTM,*) ' !!! THERE WAS 1 FATAL ERROR !!!'
      ELSE IF (IERR .GT. 1) THEN
         WRITE(NTM,*) ' !!! THERE WERE ',IERR,' FATAL ERRORS !!!'
      END IF
C

      RETURN
      END
C=======================================================================
C
      SUBROUTINE GN03ER(IOSTAT)
      USE GNKIND
C
C     PRINT A DESCRIPTIVE MESSAGE FOR A GIVEN IOSTAT VALUE
C
      INTEGER(KIND=LONG) IOSTAT
C
      INTEGER IOLIST
      COMMON /GNC11I/ IOLIST(10)
      INTEGER NOT
C

C
      CHARACTER*3  GROUP
      CHARACTER*11 CIOSTA
C
      WRITE(CIOSTA, '(I11)') IOSTAT
C
      NOT = IOLIST(4)
C
      GROUP = 'lib'
      IF (IOSTAT .LT. 900) GROUP = 'sys'
      WRITE(NOT,1000) GROUP, TRIM(ADJUSTL(CIOSTA))
C
 1000 FORMAT(
     *5X,'USE THE UNICOS COMMAND ''explain ',A3,'-',A,''' TO GET A'/
     *5X,'DESCRIPTION OF THE ABOVE RUNTIME ERROR.'/)
C

C
      RETURN

      END
