C**********************************************************************
C                              GNLB15
C**********************************************************************
C
C     SUBROUTINE NAME: GNLB15
C
C     CREATED ON: 3/13/91        BY: HAROLD THOMAS
C
C     PURPOSE: CALCULATE LIBRARY ELEMENT SECTION PROPERTIES FOR ELEMENT
C              TYPE 15.
C
C     PARAMETER LIST: (CSD,V,SP,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: CSD(*) - THE ELEMENT CROSS SECTIONAL DIMESIONS.
C            V        - POISSON RATIO.
C            IERR   - THE ERROR SWITCH.
C
C     OUTPUT: SP(*) - THE ELEMENT SECTION PROPERTIES.
C
C     CALLED BY: GN04LB
C
C     CALLS: NONE
C
C     ALGORITHM:
C
C     1. CALCULATE SECTION PROPERTIES.
C
C**********************************************************************
C
      SUBROUTINE GNLB15(CSD,V,SP,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION CSD(*),SP(*),V
C
      IERR = 2
C
      RETURN
      END
C**********************************************************************
C                              GNLB16
C**********************************************************************
C
C     SUBROUTINE NAME: GNLB16
C
C     CREATED ON: 3/13/91        BY: HAROLD THOMAS
C
C     PURPOSE: CALCULATE LIBRARY ELEMENT SECTION PROPERTIES FOR ELEMENT
C              TYPE 16.
C
C     PARAMETER LIST: (CSD,V,SP,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: CSD(*) - THE ELEMENT CROSS SECTIONAL DIMESIONS.
C            V        - POISSON RATIO.
C            IERR   - THE ERROR SWITCH.
C
C     OUTPUT: SP(*) - THE ELEMENT SECTION PROPERTIES.
C
C     CALLED BY: GN04LB
C
C     CALLS: NONE
C
C     ALGORITHM:
C
C     1. CALCULATE SECTION PROPERTIES.
C
C**********************************************************************
C
      SUBROUTINE GNLB16(CSD,V,SP,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION CSD(*),SP(*),V
C
      IERR = 2
C
      RETURN
      END
C**********************************************************************
C                              GNLB17
C**********************************************************************
C
C     SUBROUTINE NAME: GNLB17
C
C     CREATED ON: 3/13/91        BY: HAROLD THOMAS
C
C     PURPOSE: CALCULATE LIBRARY ELEMENT SECTION PROPERTIES FOR ELEMENT
C              TYPE 17.
C
C     PARAMETER LIST: (CSD,V,SP,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: CSD(*) - THE ELEMENT CROSS SECTIONAL DIMESIONS.
C            V        - POISSON RATIO.
C            IERR   - THE ERROR SWITCH.
C
C     OUTPUT: SP(*) - THE ELEMENT SECTION PROPERTIES.
C
C     CALLED BY: GN04LB
C
C     CALLS: NONE
C
C     ALGORITHM:
C
C     1. CALCULATE SECTION PROPERTIES.
C
C**********************************************************************
C
      SUBROUTINE GNLB17(CSD,V,SP,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION CSD(*),SP(*),V
C
      IERR = 2
C
      RETURN
      END
C**********************************************************************
C                              GNLB18
C**********************************************************************
C
C     SUBROUTINE NAME: GNLB18
C
C     CREATED ON: 3/13/91        BY: HAROLD THOMAS
C
C     PURPOSE: CALCULATE LIBRARY ELEMENT SECTION PROPERTIES FOR ELEMENT
C              TYPE 18.
C
C     PARAMETER LIST: (CSD,V,SP,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: CSD(*) - THE ELEMENT CROSS SECTIONAL DIMESIONS.
C            V        - POISSON RATIO.
C            IERR   - THE ERROR SWITCH.
C
C     OUTPUT: SP(*) - THE ELEMENT SECTION PROPERTIES.
C
C     CALLED BY: GN04LB
C
C     CALLS: NONE
C
C     ALGORITHM:
C
C     1. CALCULATE SECTION PROPERTIES.
C
C**********************************************************************
C
      SUBROUTINE GNLB18(CSD,V,SP,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION CSD(*),SP(*),V
C
      IERR = 2
C
      RETURN
      END
C**********************************************************************
C                              GNLB19
C**********************************************************************
C
C     SUBROUTINE NAME: GNLB19
C
C     CREATED ON: 3/13/91        BY: HAROLD THOMAS
C
C     PURPOSE: CALCULATE LIBRARY ELEMENT SECTION PROPERTIES FOR ELEMENT
C              TYPE 19.
C
C     PARAMETER LIST: (CSD,V,SP,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: CSD(*) - THE ELEMENT CROSS SECTIONAL DIMESIONS.
C            V        - POISSON RATIO.
C            IERR   - THE ERROR SWITCH.
C
C     OUTPUT: SP(*) - THE ELEMENT SECTION PROPERTIES.
C
C     CALLED BY: GN04LB
C
C     CALLS: NONE
C
C     ALGORITHM:
C
C     1. CALCULATE SECTION PROPERTIES.
C
C**********************************************************************
C
      SUBROUTINE GNLB19(CSD,V,SP,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION CSD(*),SP(*),V
C
      IERR = 2
C
      RETURN
      END
C**********************************************************************
C                              GNLB20
C**********************************************************************
C
C     SUBROUTINE NAME: GNLB20
C
C     CREATED ON: 3/13/91        BY: HAROLD THOMAS
C
C     PURPOSE: CALCULATE LIBRARY ELEMENT SECTION PROPERTIES FOR ELEMENT
C              TYPE 20.
C
C     PARAMETER LIST: (CSD,V,SP,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: CSD(*) - THE ELEMENT CROSS SECTIONAL DIMESIONS.
C            V        - POISSON RATIO.
C            IERR   - THE ERROR SWITCH.
C
C     OUTPUT: SP(*) - THE ELEMENT SECTION PROPERTIES.
C
C     CALLED BY: GN04LB
C
C     CALLS: NONE
C
C     ALGORITHM:
C
C     1. CALCULATE SECTION PROPERTIES.
C
C**********************************************************************
C
      SUBROUTINE GNLB20(CSD,V,SP,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION CSD(*),SP(*),V
C
      IERR = 2
C
      RETURN
      END
C**********************************************************************
C                              GNLB21
C**********************************************************************
C
C     SUBROUTINE NAME: GNLB21
C
C     CREATED ON: 3/13/91        BY: HAROLD THOMAS
C
C     PURPOSE: CALCULATE LIBRARY ELEMENT SECTION PROPERTIES FOR ELEMENT
C              TYPE 21.
C
C     PARAMETER LIST: (CSD,V,SP,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: CSD(*) - THE ELEMENT CROSS SECTIONAL DIMESIONS.
C            V        - POISSON RATIO.
C            IERR   - THE ERROR SWITCH.
C
C     OUTPUT: SP(*) - THE ELEMENT SECTION PROPERTIES.
C
C     CALLED BY: GN04LB
C
C     CALLS: NONE
C
C     ALGORITHM:
C
C     1. CALCULATE SECTION PROPERTIES.
C
C**********************************************************************
C
      SUBROUTINE GNLB21(CSD,V,SP,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION CSD(*),SP(*),V
C
      IERR = 2
C
      RETURN
      END
C**********************************************************************
C                              GNLB22
C**********************************************************************
C
C     SUBROUTINE NAME: GNLB22
C
C     CREATED ON:      8/31/92        BY: HAROLD THOMAS
C
C     PURPOSE: CHECKING ROUTINE FOR DESIGN LIBRARY PLATE ELEMENTS.
C
C     PARAMETER LIST: (CSD,V,SP,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: CSD(2) - THE ELEMENT CROSS SECTIONAL DIMESIONS.
C            V        - POISSON RATIO.
C            IERR   - THE ERROR SWITCH.
C
C     OUTPUT: SP(2) - THE ELEMENT SECTION PROPERTIES.
C
C     CALLED BY: GN61UP, GN16UP,GN40LB
C
C     CALLS: NONE
C
C     ALGORITHM:
C
C     1. CALCULATE SECTION PROPERTIES.
C
C**********************************************************************
C
      SUBROUTINE GNLB22(CSD,V,SP,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION CSD(1), SP(2),V
C
      IERR = 0
C
C     SOLID PLATE
C
      T=CSD(1)
C
      SP(1) = T
      SP(2) = T**3/12.0D0
C
      RETURN
      END

C**********************************************************************
C                              GNLB23
C**********************************************************************
C
C     SUBROUTINE NAME: GNLB23
C
C     CREATED ON:      8/31/92        BY: HAROLD THOMAS
C
C     PURPOSE: CHECKING ROUTINE FOR DESIGN LIBRARY BEAM ELEMENTS.
C
C     PARAMETER LIST: (CSD,V,SP,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: CSD(2) - THE ELEMENT CROSS SECTIONAL DIMESIONS.
C            V        - POISSON RATIO.
C            IERR   - THE ERROR SWITCH.
C
C     OUTPUT: SP(2) - THE ELEMENT SECTION PROPERTIES.
C
C     CALLED BY: GN61UP, GN16UP,GN40LB
C
C     CALLS: NONE
C
C     ALGORITHM:
C
C     1. CALCULATE SECTION PROPERTIES.
C
C**********************************************************************
C
      SUBROUTINE GNLB23(CSD,V,SP,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION CSD(2), SP(2),V
C
      IERR = 0
C
      B=CSD(1)
      H=CSD(2)
      A = B*H
      RI = B*H*H*H/12.0D0
C
      SP(1) = A
      SP(2) = RI
C
      RETURN
      END

C**********************************************************************
C                              GNLB24
C**********************************************************************
C
C     SUBROUTINE NAME: GNLB24
C
C     CREATED ON: 3/13/91        BY: HAROLD THOMAS
C
C     PURPOSE: CALCULATE LIBRARY ELEMENT SECTION PROPERTIES FOR ELEMENT
C              TYPE 24.
C
C     PARAMETER LIST: (CSD,V,SP,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: CSD(*) - THE ELEMENT CROSS SECTIONAL DIMESIONS.
C            V        - POISSON RATIO.
C            IERR   - THE ERROR SWITCH.
C
C     OUTPUT: SP(*) - THE ELEMENT SECTION PROPERTIES.
C
C     CALLED BY: GN04LB
C
C     CALLS: NONE
C
C     ALGORITHM:
C
C     1. CALCULATE SECTION PROPERTIES.
C
C**********************************************************************
C
      SUBROUTINE GNLB24(CSD,V,SP,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION CSD(*),SP(*),V
C
      IERR = 2
C
      RETURN
      END
C**********************************************************************
C                              GNLB25
C**********************************************************************
C
C     SUBROUTINE NAME: GNLB25
C
C     CREATED ON: 3/13/91        BY: HAROLD THOMAS
C
C     PURPOSE: CALCULATE LIBRARY ELEMENT SECTION PROPERTIES FOR ELEMENT
C              TYPE 25.
C
C     PARAMETER LIST: (CSD,V,SP,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: CSD(*) - THE ELEMENT CROSS SECTIONAL DIMESIONS.
C            V        - POISSON RATIO.
C            IERR   - THE ERROR SWITCH.
C
C     OUTPUT: SP(*) - THE ELEMENT SECTION PROPERTIES.
C
C     CALLED BY: GN04LB
C
C     CALLS: NONE
C
C     ALGORITHM:
C
C     1. CALCULATE SECTION PROPERTIES.
C
C**********************************************************************
C
      SUBROUTINE GNLB25(CSD,V,SP,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION CSD(*),SP(*),V
C
      IERR = 2
C
      RETURN
      END
C**********************************************************************
C                              GNLBIN
C**********************************************************************
C
C     SUBROUTINE NAME: GNLBIN
C
C     CREATED ON: 2003-04-14         BY: Brian C. Watson
C
C     PURPOSE: INITIALIZATION ROUTINE
C
C     PARAMETER LIST: (CSD,FORCE,STRESS,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: 
C        STRING - full path of the user shared object (DLL)
C
C     OUTPUT: 
C        IERR - error code
C        STRING - an error message if IERR /= 0 (nul-terminated)
C
C     CALLED BY:
C
C     CALLS: NONE
C
C     ALGORITHM:
C
C     1. 
C
C     NOTE:  THIS IS A DUMMY ROUTINE FOR THE glba.f FILE.
C            THIS ROUTINE ONLY WORKS WITH THE DEFAULT DRESP3/DLIB
C            ROUTINES.
C
C**********************************************************************
C
      SUBROUTINE GNLBIN(IWHICH, IERR, STRING)
C
      CHARACTER*(*) STRING
C
      IERR = 0
C
      RETURN
      END
C**********************************************************************
C                              GN4015
C**********************************************************************
C
C     SUBROUTINE NAME: GN4015
C
C     CREATED ON: 3/13/91            BY: HAROLD THOMAS
C
C     PURPOSE: CALCULATE THE ELEMENT STRESSES FOR LIBRARY ELEMENT NUMBER
C              15
C
C     PARAMETER LIST: (CSD,FORCE,STRESS,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: CSD(*)   - THE ELEMENT CROSS SECTIONAL DIMENSIONS.
C            FORCE(*) - THE ELEMENT FORCES.
C
C     OUTPUT: STRESS(*) - THE ELEMENT STRESSES.
C
C     CALLED BY: GN40LB
C
C     CALLS: NONE
C
C     ALGORITHM:
C
C     1. CALCULATE ELEMENT STRESSES 
C
C**********************************************************************
C
      SUBROUTINE GN4015(CSD,FORCE,STRESS,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION CSD(*), FORCE(*), STRESS(*)
C
      IERR = 2
C
      RETURN
      END
C**********************************************************************
C                              GN4016
C**********************************************************************
C
C     SUBROUTINE NAME: GN4016
C
C     CREATED ON: 3/13/91            BY: HAROLD THOMAS
C
C     PURPOSE: CALCULATE THE ELEMENT STRESSES FOR LIBRARY ELEMENT NUMBER
C              16
C
C     PARAMETER LIST: (CSD,FORCE,STRESS,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: CSD(*)   - THE ELEMENT CROSS SECTIONAL DIMENSIONS.
C            FORCE(*) - THE ELEMENT FORCES.
C
C     OUTPUT: STRESS(*) - THE ELEMENT STRESSES.
C
C     CALLED BY: GN40LB
C
C     CALLS: NONE
C
C     ALGORITHM:
C
C     1. CALCULATE ELEMENT STRESSES 
C
C**********************************************************************
C
      SUBROUTINE GN4016(CSD,FORCE,STRESS,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION CSD(*), FORCE(*), STRESS(*)
C
      IERR = 2
C
      RETURN
      END
C**********************************************************************
C                              GN4017
C**********************************************************************
C
C     SUBROUTINE NAME: GN4017
C
C     CREATED ON: 3/13/91            BY: HAROLD THOMAS
C
C     PURPOSE: CALCULATE THE ELEMENT STRESSES FOR LIBRARY ELEMENT NUMBER
C              17
C
C     PARAMETER LIST: (CSD,FORCE,STRESS,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: CSD(*)   - THE ELEMENT CROSS SECTIONAL DIMENSIONS.
C            FORCE(*) - THE ELEMENT FORCES.
C
C     OUTPUT: STRESS(*) - THE ELEMENT STRESSES.
C
C     CALLED BY: GN40LB
C
C     CALLS: NONE
C
C     ALGORITHM:
C
C     1. CALCULATE ELEMENT STRESSES 
C
C**********************************************************************
C
      SUBROUTINE GN4017(CSD,FORCE,STRESS,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION CSD(*), FORCE(*), STRESS(*)
C
      IERR = 2
C
      RETURN
      END
C**********************************************************************
C                              GN4018
C**********************************************************************
C
C     SUBROUTINE NAME: GN4018
C
C     CREATED ON: 3/13/91            BY: HAROLD THOMAS
C
C     PURPOSE: CALCULATE THE ELEMENT STRESSES FOR LIBRARY ELEMENT NUMBER
C              18
C
C     PARAMETER LIST: (CSD,FORCE,STRESS,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: CSD(*)   - THE ELEMENT CROSS SECTIONAL DIMENSIONS.
C            FORCE(*) - THE ELEMENT FORCES.
C
C     OUTPUT: STRESS(*) - THE ELEMENT STRESSES.
C
C     CALLED BY: GN40LB
C
C     CALLS: NONE
C
C     ALGORITHM:
C
C     1. CALCULATE ELEMENT STRESSES 
C
C**********************************************************************
C
      SUBROUTINE GN4018(CSD,FORCE,STRESS,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION CSD(*), FORCE(*), STRESS(*)
C
      IERR = 2
C
      RETURN
      END
C**********************************************************************
C                              GN4019 
C**********************************************************************
C
C     SUBROUTINE NAME: GN4019
C
C     CREATED ON: 3/13/91            BY: HAROLD THOMAS
C
C     PURPOSE: CALCULATE THE ELEMENT STRESSES FOR LIBRARY ELEMENT NUMBER
C              19
C
C     PARAMETER LIST: (CSD,FORCE,STRESS,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: CSD(*)   - THE ELEMENT CROSS SECTIONAL DIMENSIONS.
C            FORCE(*) - THE ELEMENT FORCES.
C
C     OUTPUT: STRESS(*) - THE ELEMENT STRESSES.
C
C     CALLED BY: GN40LB
C
C     CALLS: NONE
C
C     ALGORITHM:
C
C     1. CALCULATE ELEMENT STRESSES 
C
C**********************************************************************
C
      SUBROUTINE GN4019(CSD,FORCE,STRESS,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION CSD(*), FORCE(*), STRESS(*)
C
      IERR = 2
C
      RETURN
      END
C**********************************************************************
C                              GN4020
C**********************************************************************
C
C     SUBROUTINE NAME: GN4020
C
C     CREATED ON: 3/13/91            BY: HAROLD THOMAS
C
C     PURPOSE: CALCULATE THE ELEMENT STRESSES FOR LIBRARY ELEMENT NUMBER
C              20
C
C     PARAMETER LIST: (CSD,FORCE,STRESS,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: CSD(*)   - THE ELEMENT CROSS SECTIONAL DIMENSIONS.
C            FORCE(*) - THE ELEMENT FORCES.
C
C     OUTPUT: STRESS(*) - THE ELEMENT STRESSES.
C
C     CALLED BY: GN40LB
C
C     CALLS: NONE
C
C     ALGORITHM:
C
C     1. CALCULATE ELEMENT STRESSES 
C
C**********************************************************************
C
      SUBROUTINE GN4020(CSD,FORCE,STRESS,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION CSD(*), FORCE(*), STRESS(*)
C
      IERR = 2
C
      RETURN
      END
C**********************************************************************
C                              GN4021
C**********************************************************************
C
C     SUBROUTINE NAME: GN4021
C
C     CREATED ON: 3/13/91            BY: HAROLD THOMAS
C
C     PURPOSE: CALCULATE THE ELEMENT STRESSES FOR LIBRARY ELEMENT NUMBER
C              21
C
C     PARAMETER LIST: (CSD,FORCE,STRESS,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: CSD(*)   - THE ELEMENT CROSS SECTIONAL DIMENSIONS.
C            FORCE(*) - THE ELEMENT FORCES.
C
C     OUTPUT: STRESS(*) - THE ELEMENT STRESSES.
C
C     CALLED BY: GN40LB
C
C     CALLS: NONE
C
C     ALGORITHM:
C
C     1. CALCULATE ELEMENT STRESSES 
C
C**********************************************************************
C
      SUBROUTINE GN4021(CSD,FORCE,STRESS,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION CSD(*), FORCE(*), STRESS(*)
C
      IERR = 2
C
      RETURN
      END
C**********************************************************************
C                              GN4022
C**********************************************************************
C
C     SUBROUTINE NAME: GN4022
C
C     CREATED ON: 8/31/92            BY: HAROLD THOMAS
C
C     PURPOSE: CHECKING ROUTINE FOR PLATE DESIGN ELEMENT.
C
C     PARAMETER LIST: (X,F,S,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: X(1) - THE ELEMENT CROSS SECTIONAL DIMENSIONS.
C            F(8) - THE ELEMENT FORCES.
C
C     OUTPUT: S(14) - THE ELEMENT STRESSES.
C             IERR  - THE ERROR SWITCH.
C
C     CALLED BY: GN40BS, GN40S4
C
C     CALLS: GN40P2
C
C     ALGORITHM:
C
C     1. CALCULATE ELEMENT STRESSES.
C
C**********************************************************************
C
      SUBROUTINE GN4022(X,F,S,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION X(1), F(8), S(14) 
C
      PARAMETER (TWO=2.0D0,TWELVE=12.0D0)
C
      IERR = 0
C
C     SOLID PLATE
C
      T=X(1)
      T3 = T*T*T
      Z1 = -T/TWO
      Z2 = T/TWO
      ZZ1 =  TWELVE*Z1/T3
      ZZ2 =  TWELVE*Z2/T3
C
      S(5) = F(1)/T - F(6)*ZZ1
      S(6) = F(2)/T - F(7)*ZZ1
      S(7) = F(3)/T - F(8)*ZZ1
      S(12) = F(1)/T - F(6)*ZZ2
      S(13) = F(2)/T - F(7)*ZZ2
      S(14) = F(3)/T - F(8)*ZZ2
      CALL GN40P2(S(5),S(1),THETA,1,0.0D0)
      CALL GN40P2(S(12),S(8),THETA,1,0.0D0)
C
      RETURN
      END
C**********************************************************************
C                              GN4023
C**********************************************************************
C
C     SUBROUTINE NAME: GN4023
C
C     CREATED ON: 8/31/92            BY: HAROLD THOMAS
C
C     PURPOSE: CHECKING ROUTINE FOR BEAM DESIGN ELEMENT.
C
C     PARAMETER LIST: (X,F,S,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: X(2) - THE ELEMENT CROSS SECTIONAL DIMENSIONS.
C            F(8) - THE ELEMENT FORCES.
C
C     OUTPUT: S(2) - THE ELEMENT STRESSES.
C             IERR  - THE ERROR SWITCH.
C
C     CALLED BY: GN40BS, GN40S4
C
C     CALLS: GN40P2
C
C     ALGORITHM:
C
C     1. CALCULATE ELEMENT STRESSES.
C
C**********************************************************************
C
      SUBROUTINE GN4023(X,F,S,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION X(2), F(12), S(2) 
C
      PARAMETER (TWO=2.0D0,TWELVE=12.0D0)
C
      IERR = 0
C
C     SOLID PLATE
C
      B=X(1)
      H=X(2)
      A = B*H
      RI = B*H*H*H/TWELVE
      C1 = B/TWO
      C2 = B/TWO
      RM1 = F(5)
      RM2 = F(12)
C
      S(1) = F(1)/A - RM1*C1/RI
      S(2) = F(1)/A - RM2*C2/RI
C
      RETURN
      END
C**********************************************************************
C                              GN4024
C**********************************************************************
C
C     SUBROUTINE NAME: GN4024
C
C     CREATED ON: 3/13/91            BY: HAROLD THOMAS
C
C     PURPOSE: CALCULATE THE ELEMENT STRESSES FOR LIBRARY ELEMENT NUMBER
C              24
C
C     PARAMETER LIST: (CSD,FORCE,STRESS,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: CSD(*)   - THE ELEMENT CROSS SECTIONAL DIMENSIONS.
C            FORCE(*) - THE ELEMENT FORCES.
C
C     OUTPUT: STRESS(*) - THE ELEMENT STRESSES.
C
C     CALLED BY: GN40LB
C
C     CALLS: NONE
C
C     ALGORITHM:
C
C     1. CALCULATE ELEMENT STRESSES 
C
C**********************************************************************
C
      SUBROUTINE GN4024(CSD,FORCE,STRESS,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION CSD(*), FORCE(*), STRESS(*)
C
      IERR = 2
C
      RETURN
      END
C**********************************************************************
C                              GN4025
C**********************************************************************
C
C     SUBROUTINE NAME: GN4025
C
C     CREATED ON: 3/13/91            BY: HAROLD THOMAS
C
C     PURPOSE: CALCULATE THE ELEMENT STRESSES FOR LIBRARY ELEMENT NUMBER
C              25
C
C     PARAMETER LIST: (CSD,FORCE,STRESS,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: CSD(*)   - THE ELEMENT CROSS SECTIONAL DIMENSIONS.
C            FORCE(*) - THE ELEMENT FORCES.
C
C     OUTPUT: STRESS(*) - THE ELEMENT STRESSES.
C
C     CALLED BY: GN40LB
C
C     CALLS: NONE
C
C     ALGORITHM:
C
C     1. CALCULATE ELEMENT STRESSES 
C
C**********************************************************************
C
      SUBROUTINE GN4025(CSD,FORCE,STRESS,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION CSD(*), FORCE(*), STRESS(*)
C
      IERR = 2
C
      RETURN
      END
C***********************************************************************
C                               GNSUB1
C***********************************************************************
C
C     SUBROUTINE NAME: GNSUB1
C
C     CREATED ON: 04/29/93       BY: HAROLD THOMAS
C
C     PURPOSE: USER SUBROUTINE NUMBER 1 FOR DRESP3 RESPONSE EVALUATION.
C
C     PARAMETER LIST: (VAR,N,VAL,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: VAR(N) - THE VECTOR OF INPUT VARIABLES.
C            N      - THE NUMBER OF VARIABLES.
C
C     OUTPUT: VAL    - THE DRESP3 RESPONSE VALUE.
C             IERR   - THE ERROR SWITCH.
C                    =0 FOR NO ERROR.
C                    =1 FOR ERROR.
C                    =2 FOR NO USER SUPPLIED ROUTINE.
C
C     CALLED BY: GN04EQ
C
C     CALLS: NONE
C
C     ALGORITHM: USER DEFINED.
C
C***********************************************************************
C
      SUBROUTINE GNSUB1(VAR,N,VAL,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION VAR(N)
C
      IERR = 2
C
      RETURN
      END
C***********************************************************************
C                              GNSUB2
C***********************************************************************
C
C     SUBROUTINE NAME: GNSUB2
C
C     CREATED ON: 04/29/93       BY: HAROLD THOMAS
C
C     PURPOSE: USER SUBROUTINE NUMBER 2 FOR DRESP3 RESPONSE EVALUATION.
C
C     PARAMETER LIST: (VAR,N,VAL,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: VAR(N) - THE VECTOR OF INPUT VARIABLES.
C            N      - THE NUMBER OF VARIABLES.
C
C     OUTPUT: VAL    - THE DRESP3 RESPONSE VALUE.
C             IERR   - THE ERROR SWITCH.
C                    =0 FOR NO ERROR.
C                    =1 FOR ERROR.
C                    =2 FOR NO USER SUPPLIED ROUTINE.
C
C     CALLED BY: GN04EQ
C
C     CALLS: NONE
C
C     ALGORITHM: USER DEFINED
C
C***********************************************************************
C
      SUBROUTINE GNSUB2(VAR,N,VAL,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION VAR(N)
      DOUBLE PRECISION X(90), Y(18)
C
      IERR = 0
C
      J = 0
C
C     GET COORDINATES
C
      DO 10 I = 1,90
         J = J + 1
         X(I) = VAR(J)
   10 CONTINUE
C
      DO 20 I = 1,18
         J = J + 1
         Y(I) = VAR(J)
   20 CONTINUE
C
      DM = 0.0
      DO 30 K = 1,17
      DO 40 L = 1,4
         I = (K-1)*5 + L
         H = Y(K)-Y(K+1)
         S = (X(I+1)-X(I))*H/2.0D0
         X2= ((X(I+1)+X(I)+X(I+5))/3.0D0)**2
         Y2= ((Y(K+1)+Y(K)*2.0D0)/3.0D0)**2
         R2= X2 + Y2
         GMX= S*H*H/18.0D0
         GMY= S*( (X(I+1)-X(I+5))*(X(I)-X(I+5))
     1            + (X(I+1)-X(I))**2 )
         GMY= GMY/18.0D0
C        DM= DM + S*R2 + GMX + GMY
         DM= GMX + GMY + S*R2 + DM
         S = (X(I+6)-X(I+5))*H/2.0D0
         X2= ((X(I+1)+X(I+6)+X(I+5))/3.0D0)**2
         Y2= ((Y(K+1)*2.0D0+Y(K))/3.0D0)**2
         R2= X2 + Y2
         GMX= S*H*H/18.0D0
         GMY= S*( (X(I+1)-X(I+5))*(X(I+1)-X(I+6))
     1           + (X(I+6)-X(I+5))**2 )
         GMY= GMY/18.0D0
C        DM= DM + S*R2 + GMX + GMY
         DM= GMX + GMY + S*R2 + DM
   40 CONTINUE
   30 CONTINUE
      VAL = DM
C
      RETURN
      END
C***********************************************************************
C                              GNSUB3
C***********************************************************************
C
C     SUBROUTINE NAME: GNSUB3
C
C     CREATED ON: 04/29/93       BY: HAROLD THOMAS
C
C     PURPOSE: USER SUBROUTINE NUMBER 3 FOR DRESP3 RESPONSE EVALUATION.
C
C     PARAMETER LIST: (VAR,N,VAL,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: VAR(N) - THE VECTOR OF INPUT VARIABLES.
C            N      - THE NUMBER OF VARIABLES.
C
C     OUTPUT: VAL    - THE DRESP3 RESPONSE VALUE.
C             IERR   - THE ERROR SWITCH.
C                    =0 FOR NO ERROR.
C                    =1 FOR ERROR.
C                    =2 FOR NO USER SUPPLIED ROUTINE.
C
C     CALLED BY: GN04EQ
C
C     CALLS: NONE
C
C     ALGORITHM: USER DEFINED
C
C***********************************************************************
C
      SUBROUTINE GNSUB3(VAR,N,VAL,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION VAR(N)
C
      IERR = 2
C
      RETURN
      END
C***********************************************************************
C                              GNSUB4
C***********************************************************************
C
C     SUBROUTINE NAME: GNSUB4
C
C     CREATED ON: 04/29/93       BY: HAROLD THOMAS
C
C     PURPOSE: USER SUBROUTINE NUMBER 4 FOR DRESP3 RESPONSE EVALUATION.
C
C     PARAMETER LIST: (VAR,N,VAL,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: VAR(N) - THE VECTOR OF INPUT VARIABLES.
C            N      - THE NUMBER OF VARIABLES.
C
C     OUTPUT: VAL    - THE DRESP3 RESPONSE VALUE.
C             IERR   - THE ERROR SWITCH.
C                    =0 FOR NO ERROR.
C                    =1 FOR ERROR.
C                    =2 FOR NO USER SUPPLIED ROUTINE.
C
C     CALLED BY: GN04EQ
C
C     CALLS: NONE
C
C     ALGORITHM: USER DEFINED
C
C***********************************************************************
C
      SUBROUTINE GNSUB4(VAR,N,VAL,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION VAR(N)
C
      IERR = 2
C
      RETURN
      END
C***********************************************************************
C                              GNSUB5
C***********************************************************************
C
C     SUBROUTINE NAME: GNSUB5
C
C     CREATED ON: 04/29/93       BY: HAROLD THOMAS
C
C     PURPOSE: USER SUBROUTINE NUMBER 5 FOR DRESP3 RESPONSE EVALUATION.
C
C     PARAMETER LIST: (VAR,N,VAL,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: VAR(N) - THE VECTOR OF INPUT VARIABLES.
C            N      - THE NUMBER OF VARIABLES.
C
C     OUTPUT: VAL    - THE DRESP3 RESPONSE VALUE.
C             IERR   - THE ERROR SWITCH.
C                    =0 FOR NO ERROR.
C                    =1 FOR ERROR.
C                    =2 FOR NO USER SUPPLIED ROUTINE.
C
C     CALLED BY: GN04EQ
C
C     CALLS: NONE
C
C     ALGORITHM: USER DEFINED
C
C***********************************************************************
C
      SUBROUTINE GNSUB5(VAR,N,VAL,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION VAR(N)
C
      IERR = 2
C
      RETURN
      END
C***********************************************************************
C                              GNSUB6
C***********************************************************************
C
C     SUBROUTINE NAME: GNSUB6
C
C     CREATED ON: 04/29/93       BY: HAROLD THOMAS
C
C     PURPOSE: USER SUBROUTINE NUMBER 6 FOR DRESP3 RESPONSE EVALUATION.
C
C     PARAMETER LIST: (VAR,N,VAL,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: VAR(N) - THE VECTOR OF INPUT VARIABLES.
C            N      - THE NUMBER OF VARIABLES.
C
C     OUTPUT: VAL    - THE DRESP3 RESPONSE VALUE.
C             IERR   - THE ERROR SWITCH.
C                    =0 FOR NO ERROR.
C                    =1 FOR ERROR.
C                    =2 FOR NO USER SUPPLIED ROUTINE.
C
C     CALLED BY: GN04EQ
C
C     CALLS: NONE
C
C     ALGORITHM: USER DEFINED
C
C***********************************************************************
C
      SUBROUTINE GNSUB6(VAR,N,VAL,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION VAR(N)
C
      IERR = 2
C
      RETURN
      END
C***********************************************************************
C                               GNSUB7
C***********************************************************************
C
C     SUBROUTINE NAME: GNSUB7
C
C     CREATED ON: 04/29/93       BY: HAROLD THOMAS
C
C     PURPOSE: USER SUBROUTINE NUMBER 7 FOR DRESP3 RESPONSE EVALUATION.
C
C     PARAMETER LIST: (VAR,N,VAL,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: VAR(N) - THE VECTOR OF INPUT VARIABLES.
C            N      - THE NUMBER OF VARIABLES.
C
C     OUTPUT: VAL    - THE DRESP3 RESPONSE VALUE.
C             IERR   - THE ERROR SWITCH.
C                    =0 FOR NO ERROR.
C                    =1 FOR ERROR.
C                    =2 FOR NO USER SUPPLIED ROUTINE.
C
C     CALLED BY: GN04EQ
C
C     CALLS: NONE
C
C     ALGORITHM: USER DEFINED.
C
C***********************************************************************
C
      SUBROUTINE GNSUB7(VAR,N,VAL,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION VAR(N)
C
      DOUBLE PRECISION X(6), Y(6), U(6), V(6)
      DATA PI/3.141590D0/
      DATA RL/100.0D0/
C
      IERR = 0
C
      J = 0
C
C     GET COORDINATES
C
      DO 10 I = 1,6
         J = J + 1
         X(I) = VAR(J)
         J = J + 1
         Y(I) = VAR(J)
   10 CONTINUE
C
C     GET DISPLACEMENTS
C
      DO 20 I = 1,6
         J = J + 1
         U(I) = VAR(J)
         J = J + 1
         V(I) = VAR(J)
   20 CONTINUE
C
C     CALCULATE DEFORMED SHAPE
C
      DO 30 I = 1,6
         X(I) = X(I) + U(I)
         Y(I) = Y(I) + V(I)
   30 CONTINUE
C
C     LEAST SQUARES FIT OF 2 TERM SINE SERIES
C
      T1 = 0.0D0
      T2 = 0.0D0
      T3 = 0.0D0
      T4 = 0.0D0
      T5 = 0.0D0
      T6 = 0.0D0
      DO 40 I = 1,6
         T1 = T1 + Y(I)**2
         T2 = T2 + SIN(PI*X(I)/RL)**2
         T3 = T3 + SIN(2.0D0*PI*X(I)/RL)**2
         T4 = T4 + 2.0D0*Y(I)*SIN(PI*X(I)/RL)
         T5 = T5 + 2.0D0*Y(I)*SIN(2.0D0*PI*X(I)/RL)
         T6 = T6 + 2.0D0*SIN(PI*X(I)/RL)*SIN(2.0D0*PI*X(I)/RL)
   40 CONTINUE
C
      B1 = T5 - (2.0D0*T4*T3)/T6
      B2 = T6 - (4.0D0*T2*T3)/T6
      A1 = B1/B2
      A2 = (T4 - 2.0D0*T2*A1)/T6
C
      VAL = A1
C
      RETURN
      END
C***********************************************************************
C                               GNSUB8
C***********************************************************************
C
C     SUBROUTINE NAME: GNSUB8
C
C     CREATED ON: 04/29/93       BY: HAROLD THOMAS
C
C     PURPOSE: USER SUBROUTINE NUMBER 8 FOR DRESP3 RESPONSE EVALUATION.
C
C     PARAMETER LIST: (VAR,N,VAL,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: VAR(N) - THE VECTOR OF INPUT VARIABLES.
C            N      - THE NUMBER OF VARIABLES.
C
C     OUTPUT: VAL    - THE DRESP3 RESPONSE VALUE.
C             IERR   - THE ERROR SWITCH.
C                    =0 FOR NO ERROR.
C                    =1 FOR ERROR.
C                    =2 FOR NO USER SUPPLIED ROUTINE.
C
C     CALLED BY: GN04EQ
C
C     CALLS: NONE
C
C     ALGORITHM: USER DEFINED.
C
C***********************************************************************
C
      SUBROUTINE GNSUB8(VAR,N,VAL,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION VAR(N)
      DOUBLE PRECISION X(6), Y(6), U(6), V(6)
      DATA PI/3.141590D0/
      DATA RL/100.0D0/
C
      IERR = 0
C
      J = 0
C
C     GET COORDINATES
C
      DO 10 I = 1,6
         J = J + 1
         X(I) = VAR(J)
         J = J + 1
         Y(I) = VAR(J)
   10 CONTINUE
C
C     GET DISPLACEMENTS
C
      DO 20 I = 1,6
         J = J + 1
         U(I) = VAR(J)
         J = J + 1
         V(I) = VAR(J)
   20 CONTINUE
C
C     CALCULATE DEFORMED SHAPE
C
      DO 30 I = 1,6
         X(I) = X(I) + U(I)
         Y(I) = Y(I) + V(I)
   30 CONTINUE
C
C     LEAST SQUARES FIT OF 2 TERM SINE SERIES
C
      T1 = 0.0D0
      T2 = 0.0D0
      T3 = 0.0D0
      T4 = 0.0D0
      T5 = 0.0D0
      T6 = 0.0D0
      DO 40 I = 1,6
         T1 = T1 + Y(I)**2
         T2 = T2 + SIN(PI*X(I)/RL)**2
         T3 = T3 + SIN(2.0D0*PI*X(I)/RL)**2
         T4 = T4 + 2.0D0*Y(I)*SIN(PI*X(I)/RL)
         T5 = T5 + 2.0D0*Y(I)*SIN(2.0D0*PI*X(I)/RL)
         T6 = T6 + 2.0D0*SIN(PI*X(I)/RL)*SIN(2.0D0*PI*X(I)/RL)
   40 CONTINUE
C
      B1 = T5 - (2.0D0*T4*T3)/T6
      B2 = T6 - (4.0D0*T2*T3)/T6
      A1 = B1/B2
      A2 = (T4 - 2.0D0*T2*A1)/T6
C
      VAL = A2
C
      RETURN
      END
C***********************************************************************
C                              GNSUB9
C***********************************************************************
C
C     SUBROUTINE NAME: GNSUB9
C
C     CREATED ON: 04/29/93       BY: HAROLD THOMAS
C
C     PURPOSE: USER SUBROUTINE NUMBER 9 FOR DRESP3 RESPONSE EVALUATION.
C
C     PARAMETER LIST: (VAR,N,VAL,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: VAR(N) - THE VECTOR OF INPUT VARIABLES.
C            N      - THE NUMBER OF VARIABLES.
C
C     OUTPUT: VAL    - THE DRESP3 RESPONSE VALUE.
C             IERR   - THE ERROR SWITCH.
C                    =0 FOR NO ERROR.
C                    =1 FOR ERROR.
C                    =2 FOR NO USER SUPPLIED ROUTINE.
C
C     CALLED BY: GN04EQ
C
C     CALLS: NONE
C
C     ALGORITHM: USER DEFINED
C
C***********************************************************************
C
      SUBROUTINE GNSUB9(VAR,N,VAL,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION VAR(N)
C
      IERR = 2
C
      RETURN
      END
C**********************************************************************
C                              GNMASS
C**********************************************************************
C
C     SUBROUTINE NAME: GNMASS
C
C     CREATED ON: 01/07/97           BY: JUAN-PABLO LEIVA
C
C     PURPOSE: INTERFACE ROUTINE TO CALCULATE REDUCED MASS MATRICES.
C              THE CALCULATION CAN BE LOADCASE DEPENDANT AND/OR
C              DESIGN VARIABLE DEPENDANT.
C
C     PARAMETER LIST:  (UDV,IASET,NDVT,NEQR,NEQRL,IUSERL,
C                       RMASS,IERROR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: UDV(NDVT)    - THE DESIGN VARIABLE VALUES IN USER
C                           DEFINED ORDER.
C            IASET(1,NEQR) - GRIDS ASSOCIATED TO ASET DEGREE OF FREEDOM
C                 (2,NEQR) - COMPONENT ASSOCIATED TO ASET DEGREE OF
C                            FREEDOM. OPTIONALLY, THIS ARRAY MAY BE
C                            CHANGED BY THE USER TO CHANGE ORDER OF
C                            GRID AND COMPONENT.
C            NDVT   - THE TOTAL NUMBER OF DESIGN VARIABLES.
C            NEQR   - THE NUMBER OF ASET DEGREE OF FREEDOM.
C            NEQRL  - DIMENSION OF RMASS [=NEQR*(NEQR+1)/2)]
C            IUSERL - LOADCASE NUMBER
C
C     OUTPUT: RMASS(NEQRL) - USER CALCULATED REDUCED MASS  MATRIX
C
C             IERROR - ERROR FLAG 
C                    =0 FOR NO ERROR.
C                    =1 FOR ERROR.
C                    =2 FOR NO USER SUPPLIED ROUTINE.
C
C     CALLED BY: GN29UM
C
C     CALLS: NONE
C
C     ALGORITHM:
C
C     1. SET THE ERROR SWITCH
C
C     2. CALCULATE MASS MATRIX
C
C**********************************************************************
C
      SUBROUTINE GNMASS(UDV,IASET,NDVT,NEQR,NEQRL,IUSERL,
     *                  RMASS,IERROR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      PARAMETER (ZERO = 0.0D0)
C
C     DOUBLE PRECISION UDV(NDVT),  RMASS(NEQRL) 
C
      DOUBLE PRECISION UDV(*),     RMASS(NEQRL) 
C
      INTEGER  IASET(2,NEQR)
C
      COMMON /GNC11I/ IOLIST(10)
      COMMON /GNC11K/ KIOLST(20)
C
C     GET OUTPUT FILE UNIT NUMBER
C
      NOT = IOLIST(4)
C
C     GET UNIT NUMBER FOR USER DEFINED MASS MATRIX
C
      NMS = KIOLST(10)
C
C     SET ERROR SWITCH 
C
C     !!!  NOTE: AFTER MODIFYING THIS ROUTINE, REMOVE THE NEXT TWO LINES
      IERROR = 2
      RETURN
C
      IERROR = 1
C
C     CALCULATE THE MASS MATRIX
C
C     (REPLACE NEXT LINES BY ACTUAL CALCULATIONS)
C
      IF (IUSERL.LT.10) THEN
C
          OPEN (UNIT=NMS, FILE='USER.1.MASS', STATUS='OLD',
     $          FORM='UNFORMATTED', IOSTAT = IERR, ERR=999)

          READ(NMS, IOSTAT=IERR, ERR=999) IDELEM,INNEQR
          IF (INNEQR.NE.NEQR) THEN
             WRITE(NOT,*) ' WRONG NUMBER OF DOF IN MASS FILE'
             WRITE(NOT,*) ' INNEQR = ', INNEQR
             WRITE(NOT,*) ' NEQR = ', NEQR
             RETURN
          ENDIF
          READ(NMS, IOSTAT=IERR, ERR=999)
     $               (IASET(1,I),IASET(2,I),I=1,NEQR)
          K=1
          DO I=1,NEQR
             KK=K+NEQR-I
             READ(NMS, IOSTAT=IERR, ERR=999) (RMASS(J),J=K,KK)
             K = KK +1
          END DO

          CLOSE (NMS)

          IERROR = 0
C
      ELSE IF (IUSERL.LT.20) THEN
C
          OPEN (UNIT=NMS, FILE='USER.2.MASS', STATUS='OLD',
     $          FORM='UNFORMATTED', IOSTAT = IERR, ERR=999)

          READ(NMS, IOSTAT=IERR, ERR=999) IDELEM,INNEQR
          IF (INNEQR.NE.NEQR) THEN
             WRITE(NOT,*) ' WRONG NUMBER OF DOF IN MASS FILE'
             WRITE(NOT,*) ' INNEQR = ', INNEQR
             WRITE(NOT,*) ' NEQR = ', NEQR
             RETURN
          ENDIF
          READ(NMS, IOSTAT=IERR, ERR=999)
     $               (IASET(1,I),IASET(2,I),I=1,NEQR)
          K=1
          DO I=1,NEQR
             KK=K+NEQR-I
             READ(NMS, IOSTAT=IERR, ERR=999) (RMASS(J),J=K,KK)
             K = KK +1
          END DO

          CLOSE (NMS)

          IERROR = 0
C
      END IF
C
      RETURN
 999  CONTINUE
      WRITE(NOT,*) ' I/O ERROR IN GNMASS'
      WRITE(NOT,*) ' IOSTAT = ', IERR
      RETURN
      END
