C**********************************************************************
C                              GNUSER
C**********************************************************************
C
C     SUBROUTINE NAME: GNUSER
C
C     CREATED ON: 06/02/1999           BY: Brian C. Watson
C     MODIFIED ON: 2006-03-20 By Brian C. Watson
C                           Use GN03FN to access project name
C     MODIFIED ON: 2006-08-25 By Brian C. Watson
C                           Allow user sensitivities
C
C     PURPOSE: CALLS USER PROGRAM TO CALCULATE RESPONSES.
C
C     PARAMETER LIST: (UDV,RESPU,USENS,ICODE,ICUSER,NDVT,NRESPU)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: UDV(NDVT)      - THE DESIGN VARIABLE VALUES IN USER
C                             DEFINED ORDER.
C            ICUSER(NRESPU) - THE LIST OF RETAINED USER DEFINED
C                             RESPONSES.
C            ICODE  - IF ICODE = 0 THEN RETURN THE USER DEFINED
C                     RESPONSES, IF ICODE = 1 THEN RETURN THE USER
C                     DEFINED SENSITIVITY MATRIX.
C            NDVT   - THE TOTAL NUMBER OF DESIGN VARIABLES.
C            NRESPU - THE NUMBER OF USER DEFINED RESPONSES.
C
C     OUTPUT: RESPU(NRESPU)      - THE USER DEFINED RESPONSE VALUES.
C             USENS(NDVT,NRESPU) - THE USER DEFINED SENSITIVITY MATRIX.
C
C     CALLED BY: GN41RU, GN41UG
C
C     CALLS: NONE
C
C     ALGORITHM:
C
C     1. WRITE THE DESIGN VARIABLE VALUES TO A FILE
C     2. CALL THE USER PROGRAM gnuser TO CALCULATE THE RESPONSES
C     3. READ A FILE TO GET THE RESPONSE VALUES
C
C**********************************************************************
C
      SUBROUTINE GNUSER(UDV,RESPU,USENS,ICODE,ICUSER,NDVT,NRESPU)
C
      IMPLICIT NONE
C
      INTEGER ICODE, NDVT, NRESPU
C
      INTEGER ICUSER(NRESPU)
C
      DOUBLE PRECISION UDV(NDVT), RESPU(NRESPU), USENS(NDVT,NRESPU)
C
      INTEGER NSF, NOT, I, J, LUFN, LIFN, NICUSR, IERR, IER1
C
      CHARACTER*1024 BUFFER
      CHARACTER*256 DVFILE
      CHARACTER*256 RSFILE
      CHARACTER*256 ICFILE
      CHARACTER*3  FSTAT
      CHARACTER*9  FORM
      CHARACTER*8  CICUSR
      LOGICAL LEX, LOP
C
      INTEGER IOLIST
      COMMON /GNC11I/ IOLIST(10)
C 2006-03-20 -- BCW
CNE      CHARACTER*20 PNAME, PREFIX
CNE      COMMON /GNC12N/ PNAME, PREFIX
      CHARACTER*60 USERFN
      COMMON /GNC12U/ USERFN
C
CNE      INTEGER   LENPN, LENFX
CNEC
CNE      SAVE      LENPN, LENFX
CNEC
CNE      DATA      LENPN/0/, LENFX/0/
CNEC
      DATA      FORM /'FORMATTED'/
C
      NOT = IOLIST(4)
      NSF = IOLIST(5)
C
      LUFN = LEN_TRIM(USERFN)
      IF(LUFN .EQ. 0) GO TO 995

      BUFFER = USERFN
      INQUIRE (FILE=USERFN(1:LUFN), EXIST=LEX, IOSTAT=IERR, ERR=998)
      IF (.NOT.LEX) THEN
         GO TO 996
      ENDIF
C
C 2006-03-20 -- BCW
CNEC --- FIND THE LENGTH OF PROJECT NAME AND THE LENGTH OF THE PREFIX
CNEC
CNE      IF (LENPN .EQ. 0) THEN
CNE         DO I = 1,LEN(PNAME)
CNE            IF (PNAME(I:I) .EQ. ' ') THEN
CNE              LENPN = I - 1
CNE              GO TO 20
CNE            END IF
CNE         END DO
CNE         LENPN = LEN(PNAME)
CNE  20     CONTINUE
CNE         DO I = 1,LEN(PREFIX)
CNE            IF (PREFIX(I:I) .EQ. ' ') THEN
CNE              LENFX = I - 1
CNE              GO TO 40
CNE            END IF
CNE         END DO
CNE         LENFX = LEN(PREFIX)
CNE  40     CONTINUE
CNE      END IF
C
C --- OPEN A FORMATTED SEQUENTIAL ACCESS FILE FOR THE DESIGN
C     VARIABLE VALUES
C
C 2006-03-20 -- BCW
CNE      IF (LENFX.EQ.0) THEN
CNE         LIFN = LENPN + 10
CNE         DVFILE = PNAME(1:LENPN)//'GNUSR1.txt'
CNE         RSFILE = PNAME(1:LENPN)//'GNUSR2.txt'
CNE      ELSE
CNE         LIFN = LENFX + LENPN + 10
CNE         DVFILE = PREFIX(1:LENFX)//PNAME(1:LENPN)//'GNUSR1.txt'
CNE         RSFILE = PREFIX(1:LENFX)//PNAME(1:LENPN)//'GNUSR2.txt'
CNE      END IF
      CALL GN03FN('GNUSR1.txt', DVFILE, LIFN, IER1)
      CALL GN03FN('GNUSR2.txt', RSFILE, LIFN, IER1)
      CALL GN03FN('GNUSR3.txt', ICFILE, LIFN, IER1)
C
C --- INQUIRE THE NSF STATUS
C
      BUFFER = DVFILE
      INQUIRE (UNIT=NSF, OPENED=LOP)
      IF (LOP) THEN
         GO TO 999
      END IF
C
C --- INQUIRE THE FILE STATUS
C
      INQUIRE (FILE=DVFILE(1:LIFN), EXIST=LEX, IOSTAT=IERR, ERR=998)
      IF (LEX) THEN
         FSTAT = 'OLD'
      ELSE
         FSTAT = 'NEW'
      ENDIF
C
      CALL GN03SF (NSF, DVFILE(1:LIFN), FSTAT, FORM, IERR)
      IF(IERR.NE.0) GO TO 998

      DO I=1,NDVT
         WRITE(NSF,'(1P,E20.13)') UDV(I)
      END DO
C
      CLOSE(NSF)

      IF (ICODE .EQ. 0) THEN
C        !  Calculate responses
C
         BUFFER = USERFN(1:LUFN)//' '//DVFILE(1:LIFN)//' '//
     &            RSFILE(1:LIFN)//' 0'
         CALL GN02SW(BUFFER)
C
         BUFFER = RSFILE
         FSTAT = 'OLD'
         CALL GN03SF (NSF, RSFILE(1:LIFN), FSTAT, FORM, IERR)
         IF(IERR.NE.0) GO TO 998

         DO I=1,NRESPU
            READ(NSF,*, IOSTAT=IERR, ERR=998) RESPU(I)
         END DO
C
         CLOSE(NSF, STATUS = 'DELETE', IOSTAT=IERR, ERR=998)
C
      ELSE
C        !  Calculate sensitivities
C
         INQUIRE (FILE=ICFILE(1:LIFN), EXIST=LEX, IOSTAT=IERR, ERR=998)
         IF (LEX) THEN
            FSTAT = 'OLD'
         ELSE
            FSTAT = 'NEW'
         ENDIF
C
         BUFFER = ICFILE
         CALL GN03SF (NSF, ICFILE(1:LIFN), FSTAT, FORM, IERR)
         IF(IERR.NE.0) GO TO 998

         NICUSR = 0
         DO I=1,NRESPU
            WRITE(NSF,'(I8)') ICUSER(I)
            IF (ICUSER(I) .GT. 0) NICUSR = NICUSR + 1
         END DO
C
         CLOSE(NSF)

         WRITE(CICUSR,'(I8)') NICUSR

         BUFFER = USERFN(1:LUFN)//' '//DVFILE(1:LIFN)//' '//
     &            RSFILE(1:LIFN)//' '//TRIM(ADJUSTL(CICUSR))//' '//
     &            ICFILE(1:LIFN)
         CALL GN02SW(BUFFER)
C
         BUFFER = RSFILE
         FSTAT = 'OLD'
         CALL GN03SF (NSF, RSFILE(1:LIFN), FSTAT, FORM, IERR)
         IF(IERR.NE.0) GO TO 998

         DO I=1,NRESPU
            IF (ICUSER(I) .GT. 0) THEN
               DO J=1,NDVT
                  READ(NSF,*, IOSTAT=IERR, ERR=998) USENS(J,I)
               END DO
            ENDIF
         END DO
C
         CLOSE(NSF, STATUS = 'DELETE', IOSTAT=IERR, ERR=998)
C
         FSTAT = 'OLD'
         CALL GN03SF (NSF, ICFILE(1:LIFN), FSTAT, FORM, IERR)
         IF(IERR.EQ.0)
     &      CLOSE(NSF, STATUS = 'DELETE', IOSTAT=IERR, ERR=998)

      ENDIF
C
      FSTAT = 'OLD'
      CALL GN03SF (NSF, DVFILE(1:LIFN), FSTAT, FORM, IERR)
      IF(IERR.EQ.0) CLOSE(NSF, STATUS = 'DELETE', IOSTAT=IERR, ERR=998)
C
      RETURN
C
10002 FORMAT (/5X,'ERROR MESSAGE FROM SUBROUTINE "GNUSER"'/
     *         5X,'ERROR CODE =',I7)
C
 995  CONTINUE
      WRITE (NOT,10002) 39995
      WRITE (NOT,9995)
 9995 FORMAT (
     *5X,'NO EXTERNAL PROGRAM NAME WAS SPECIFIED.'/
     *5X,'USE THE EXECUTIVE CONTROL COMMAND "GNUSER=executable_name"'/
     *5X,'TO SPECIFY THE EXTERNAL PROGRAM FOR USER RESPONSES.'/)
      CALL GN0098
C
 996  CONTINUE
      WRITE (NOT,10002) 39996
      WRITE (NOT,9996) USERFN(1:LUFN)
 9996 FORMAT (
     *5X,'THE EXTERNAL PROGRAM "',A,'" COULD NOT BE FOUND.'/)
      CALL GN0098
C
 998  CONTINUE
      WRITE (NOT,10002) 39998
      WRITE (NOT,9998) IERR, TRIM(BUFFER)
 9998 FORMAT (
     *5X,'AN I/O ERROR OCCURRED IN THE USER-RESPONSE SUBROUTINE'/
     *5X,'IOSTAT = ',I8/,
     *5X,'THIS ERROR OCCURRED WITH FILE "',
     *      A,'".'/)
      CALL GN0098
C
 999  CONTINUE
      WRITE (NOT,10002) 39999
      WRITE (NOT,9999) NSF, TRIM(BUFFER)
 9999 FORMAT (
     *5X,'NSF =',I4,' IS CONNECTED TO ANOTHER OPENED FILE.'/
     *5X,'THIS ERROR OCCURRED WHEN ATTEMPTING TO OPEN FILE "',
     *      A,'".'/)
      CALL GN0098
C
      END
