C=======================================================================
C
C     SUBROUTINE NAME: GNUPRN
C
C     PURPOSE: PRINT THE REVISION NUMBER BELOW TITLE PAGE OF GENESIS.
C
C     CREATED ON: 11/09/98         BY IKU KOSAKA
C     Modified ON: 01/22/99        BY Brian C. Watson to change the
C                                  revision code printing
C     Modified ON: 10/06/2000      BY Brian C. Watson to change beta
C                                  number to build code
C
C     PARAMETER LIST: ()
C
C     COMMON BLOCKS USED: GNC12P, GNC11I
C
C     INPUT: NONE
C
C     OUTPUT: TO THE OUTPUT FILE
C
C     COMMON:
C        NOT    - THE OUTPUT FILE'S LOGICAL UNIT NUMBER.
C        NUMCOL - THE NUMBER OF COLUMNS PER LINE.
C
C     CALLED BY: GN12TP
C
C     ALGORITHM:
C
C-----------------------------------------------------------------------
      SUBROUTINE GNUPRN ()
C
C 10/06/2000 -- BCW
      CHARACTER*17 BUILD
C
C     REVISION CODES      : NREV1,NREV2,NREV3
C
C     BETA VERSION NUMBER : NBETA
C
C 01/15/99
C      PARAMETER(NREV = 0,  NBETA= 0)
      PARAMETER(NREV1 = 0, NREV2 = 0, NREV3 = 0,  NBETA= 0)
C
      COMMON       /GNC12P/   NUMCOL,   NUMROW,  IPAGE
      COMMON       /GNC11I/   IOLIST(10)
C
C --- WRITE REVISION NUMBER.
C
      NOT = IOLIST(4)
C
      IF(NREV1+NREV2+NREV3.GT.0) THEN
         IF (NUMCOL.LT.130) THEN
            WRITE (NOT,80)  NREV1,NREV2,NREV3
         ELSE
            WRITE (NOT,132) NREV1,NREV2,NREV3
         END IF
      END IF
C
C 10/06/2000 -- BCW
CNE      IF(NBETA.GT.0) THEN
CNE         IF (NUMCOL.LT.130) THEN
CNE            WRITE (NOT,180)  NBETA
CNE         ELSE
CNE            WRITE (NOT,1132) NBETA 
CNE         END IF
CNE      END IF
C
      BUILD = '200612131534'
      IF (NBETA .GT. 0) BUILD(13:17) = ' BETA'
      IF (NUMCOL.LT.130) THEN
         WRITE (NOT,180)  BUILD
      ELSE
         WRITE (NOT,1132) BUILD 
      END IF
C
      WRITE(NOT,100)
C
 80   FORMAT (28X,'REVISION CODE 1.',I2.2,'.',I2.2,'.',I2.2/)
 132  FORMAT (54X,'REVISION CODE 1.',I2.2,'.',I2.2,'.',I2.2/)
C
C 10/06/2000 -- BCW
CNE 180  FORMAT (32X,'BETA NUMBER  ',I2/)
CNE 1132 FORMAT (60X,'BETA NUMBER  ',I2/)
 180  FORMAT (29X,'BUILD CODE ',A/)
 1132 FORMAT (55X,'BUILD CODE ',A/)
C
 100  FORMAT (/)
C
      RETURN
      END
