C***********************************************************************
C
C     PROGRAM NAME: GNUSER
C
C     CREATED ON: 02/09/2000           BY: Brian C. Watson
C     MODIFIED ON: 03/21/2000          BY: IKU KOSAKA
C
C     PURPOSE: SAMPLE PROGRAM TO CALCULATE DRESPU RESPONSES FOR GENESIS.
C
C***********************************************************************
      PROGRAM GNUSER
      IMPLICIT NONE
C
C     !  THIS PROGRAM SHOULD KNOW HOW MANY DESIGN VARIABLES
C     !  THERE ARE.  HOWEVER, SOME RESPONSES ARE FLEXIBLE ENOUGH
C     !  TO NOT DEPEND ON THE NUMBER (E.G., SUM ALL THE DVARS)
C
C     !  MAXDV IS THEREFORE EITHER THE EXACT NUMBER OF DVARS
C     !  OR AN UPPER BOUND ON THE NUMBER
C
C     !  WARNING -- IF THERE ARE MORE THAN MAXDV VALUES IN THE FILE
C     !  THIS PROGRAM WILL SILENTLY IGNORE THE EXTRA ONES
C
      INTEGER MAXDV
      PARAMETER (MAXDV = 5000)
      DOUBLE PRECISION DVARS(MAXDV)
C
C     !  THIS PROGRAM MUST KNOW HOW MANY RESPONSES IT CALCULATES
C
C     !  SET NRESPU TO THE NUMBER OF RESPONSES
C
C     !  WARNING -- IF IT CALCULATES MORE THAN GENESIS EXPECTS,
C     !  THEN GENESIS WILL SILENTLY IGNORE THE EXTRA RESPONSES
C     ! (GENESIS EXPECTS ONE RESPONSE PER DRESPU ENTRY IN THE
C     !  INPUT FILE)
C
      INTEGER NRESPU
      PARAMETER (NRESPU = 2)
      DOUBLE PRECISION RESPU(NRESPU)
      INTEGER ICUSER(NRESPU)
      DOUBLE PRECISION DAVE(MAXDV)
      DOUBLE PRECISION DSDEV(MAXDV)
C
C     !  LOCAL VARIABLE DECLARATIONS
C
      INTEGER NARG
      CHARACTER*80 DVFILE, RSFILE
      CHARACTER*8  CICODE
      CHARACTER*80 ICFILE
      DOUBLE PRECISION VAL
C
      INTEGER NTM, NDV, I, J, IR, ICODE, IERR
      LOGICAL LEX
C
      INTEGER IARGC
      EXTERNAL IARGC
C
C     !  SET UNIT NUMBERS FOR ERROR MESSAGES
C
      NTM = 0
C
C     !  GET THE DESIGN VARIABLE AND RESPONSE FILE NAMES
C
      NARG = IARGC()
      IF (NARG.LT.2) THEN
         WRITE (NTM,1998)
 1998    FORMAT (
     $5X,'AN ERROR OCCURRED IN THE USER-RESPONSE PROGRAM:'/
     $5X,'TWO COMMAND LINE ARGUMENTS EXPECTED'/)
         GO TO 9999
      ENDIF
      CALL GETARG(1,DVFILE)
      CALL GETARG(2,RSFILE)
      IF (NARG.GE.4) THEN
         CALL GETARG(3,CICODE)
         READ (CICODE, '(I8)') ICODE
         IF (ICODE .GT. 0) THEN
            CALL GETARG(4,ICFILE)
            INQUIRE (FILE=ICFILE, EXIST=LEX, IOSTAT=IERR, ERR=999)
            IF (.NOT.LEX) THEN
               WRITE (NTM,2997)
 2997          FORMAT (
     $      5X,'AN ERROR OCCURRED IN THE USER-RESPONSE PROGRAM:'/
     $      5X,'ICUSER FILE NOT FOUND'/)
               GO TO 9999
            ENDIF
C
            OPEN (12, FILE=ICFILE, STATUS='OLD', FORM='FORMATTED',
     *            IOSTAT=IERR, ERR=999)
            DO I=1,ICODE
               READ(12,'(I8)',IOSTAT=IERR,ERR=999) ICUSER(I)
            END DO
            CLOSE(12)
         ENDIF
      ELSE
         ICODE = 0
      ENDIF
C
C     !  READ THE DESIGN VARIABLE VALUES FROM THE DV FILE
C
      INQUIRE (FILE=DVFILE, EXIST=LEX, IOSTAT=IERR, ERR=999)
      IF (.NOT.LEX) THEN
         WRITE (NTM,2998)
 2998    FORMAT (
     $5X,'AN ERROR OCCURRED IN THE USER-RESPONSE PROGRAM:'/
     $5X,'DESIGN VARIABLE FILE NOT FOUND'/)
         GO TO 9999
      ENDIF
C
      OPEN (12, FILE=DVFILE, STATUS='OLD', FORM='FORMATTED',
     *      IOSTAT=IERR, ERR=999)
C
      NDV = 0
      DO I=1,MAXDV
         READ(12,'(F20.0)',IOSTAT=IERR,ERR=999,END=3000) VAL
         NDV = NDV + 1
         DVARS(NDV) = VAL
      END DO
 3000 CONTINUE
C
      CLOSE(12)
C
      OPEN (12, FILE=RSFILE, STATUS='UNKNOWN', FORM='FORMATTED',
     $      IOSTAT=IERR, ERR=999)
C
      IF (ICODE .EQ. 0) THEN
C        !  CALCULATE RESPONSES HERE
C
C        ! COMPUTE AVERAGE AND STANDARD DEVIATION
C
         CALL AVESTA(DVARS,NDV,RESPU(1),RESPU(2))
C
C        !  WRITE THE RESPONSE VALUES IN THE RESPONSE FILE
C
         DO I=1,NRESPU
            WRITE(12,'(1P,E20.13)') RESPU(I)
         END DO
      ELSE
C        !  CALCULATE SENSITIVIES HERE
         CALL DAVESTA(DVARS,NDV,DAVE,DSDEV)
         DO I=1,ICODE
            IR = ICUSER(I)
            IF (IR .EQ. 1) THEN
               DO J=1,NDV
                  WRITE(12,'(1P,E20.13)') DAVE(J)
               END DO
            ELSE IF (IR .EQ. 2) THEN
               DO J=1,NDV
                  WRITE(12,'(1P,E20.13)') DSDEV(J)
               END DO
            ELSE
               DO J=1,NDV
                  WRITE(12,'(1P,E20.13)') 0.0D0
               END DO
            ENDIF
         END DO

      ENDIF
C
      CLOSE (12)
C
C     !  FINISHED
C
      GO TO 9999
C
 999  CONTINUE
      WRITE (NTM,9998) IERR
 9998 FORMAT (
     $5X,'AN I/O ERROR OCCURRED IN THE USER-RESPONSE PROGRAM:'/
     $5X,'IOSTAT = ',I8/)
C
 9999 CONTINUE
      END
C
C***********************************************************************
C
C     PROGRAM NAME: AVESTA
C
C     PURPOSE: COMPUTE AVERAGE AND STANDARD DEVIATION.
C
C     CREATED ON: 03/21/2000           BY:  IKU KOSAKA
C
C     DVAR(NDVAR) : DESIGN VARIABLE VALUES
C
C     NDVAR : NUMBER OF DESIGN VARIABLE
C     NRESP : NUMBER OF RESPONSE
C
C***********************************************************************
C
      SUBROUTINE AVESTA(DVAR,NDVAR,AVE,SDEV)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION DVAR(NDVAR)
C
C     ! COMPUTE AVERAGE
C
      AVE = 0.0D0
C
      DO I = 1, NDVAR
         AVE = AVE + DVAR(I)
      END DO
C
      AVE = AVE/REAL(NDVAR)
C
C     ! COMPUTE VARIATION
C
      VAR = 0.0D0
C
      DO I = 1, NDVAR
         VAR = VAR + (AVE - DVAR(I))**2/REAL(NDVAR)
      END DO
C
C     ! COMPUTE STANDARD DEVIATION
C
      SDEV = DSQRT(VAR)
C
      RETURN
      END
C***********************************************************************
C
C     PROGRAM NAME: DAVESTA
C
C     PURPOSE: COMPUTE DERIVATIVES OF AVERAGE AND STANDARD DEVIATION.
C
C     CREATED ON: 2006-08-25           BY:  BRIAN C. WATSON
C
C     DVAR(NDVAR) : DESIGN VARIABLE VALUES
C
C     NDVAR : NUMBER OF DESIGN VARIABLE
C     NRESP : NUMBER OF RESPONSE
C
C***********************************************************************
C
      SUBROUTINE DAVESTA(DVARS,NDV,DAVE,DSDEV)
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION DVARS(NDV)
      DOUBLE PRECISION DAVE(NDV)
      DOUBLE PRECISION DSDEV(NDV)
C
C     ! COMPUTE AVERAGE
C
      AVE = 0.0D0
C
      DO I = 1, NDV
         AVE = AVE + DVARS(I)
      END DO
C
      AVE = AVE/REAL(NDV)
      DAVG = 1.0D0/REAL(NDV)
C
      DO K=1,NDV
         DO J=1,NDV
            DAVE(J) = 0.0D0
         END DO
         DAVE(K) = 1.0D0
C
C        ! COMPUTE VARIATION
C
         VAR = 0.0D0
         DVAR = 0.0D0
C
         DO I = 1, NDV
            VAR = VAR + (AVE - DVARS(I))**2/REAL(NDV)
            DVAR = DVAR +
     &         2.0D0*(AVE - DVARS(I))*(DAVG - DAVE(I))/REAL(NDV)
         END DO
C
C        ! COMPUTE STANDARD DEVIATION
C
         SDEV = DSQRT(VAR)
         IF (SDEV.NE.0.0D0) THEN
            DSDEV(K) = 0.5D0/SDEV*DVAR
         ELSE
            DSDEV(K) = 0.0D0
         ENDIF
C
      END DO
C
      DO K=1,NDV
         DAVE(K) = DAVG
      END DO
C
      RETURN
      END
