      PROGRAM READSKA
C
C***********************************************************************
C     EXAMPLE PROGRAM FOR READING BINARY *.SKA (OR *.SMA) DATA FILES
C
C     THIS PROGRAM READS THE UNFORMATTED FILE AND WRITES IT TO STANDARD
C     OUTPUT AS FORMATTED DATA TO ILLUSTRATE WHAT IS IN THE FILE.
C
C     NOTE: THE FORMAT DESCRIBED FOR THE *.SKA AND *.SMA FILES
C           IN CHAPTER 7 OF "VOLUME II: REFERENCE" IS NOT CORRECT. 
C           THIS EXAMPLE PROGRAM SHOWS HOW THE DATA IN THESE
C           FILES SHOULD BE INTERPRETED.
C***********************************************************************
C
      INTEGER NEQR,ICYCLE,LOADID,ILAST,NDVI,IFIRST,NROW,IOERR,I,J,II
C
      INTEGER NEQRL
C
      INTEGER MAXAST
      PARAMETER (MAXAST = 1000)
C
      DOUBLE PRECISION SKMAA(MAXAST)
      INTEGER IWORK(2,MAXAST)
C
C OPEN BINARY *.SKA (OR *.SMA) DATA FILE
C
      OPEN (20, FILE='pnamexxyy.SKA', STATUS='OLD', 
     +      FORM='UNFORMATTED',IOSTAT=IOERR, ERR=997)
C
C       READ BASIC NUMBERS
C
      READ(20,IOSTAT=IOERR)  ICYCLE,LOADID,NEQRL,NDVI
      WRITE(*,1001) ICYCLE,LOADID,NEQRL,NDVI
C
 1001 FORMAT(
     $5X,'DESIGN CYCLE NUMBER:                        ',I8/
     $5X,'LOADCASE NUMBER:                            ',I8/
     $5X,'NUMBER OF TERMS IN LOWER TRIANGLE OF MATRIX:',I8/
     $5X,'NUMBER OF DESIGN VARIABLES:                 ',I8/)
C
      IF(NEQRL .GT. MAXAST) THEN
         WRITE(*,*) ' *** MATRIX IS TOO LARGE'
         WRITE(*,*) ' *** INCREASE MAXAST IN READSKA PROGRAM'
         STOP
      ENDIF
C
C     CALCULATE NUMBER OF DOF
C
      NEQR = (SQRT(REAL(1+8*NEQRL)) - 1)/2
C
      WRITE(*,1002) NEQR
 1002 FORMAT(
     $5X,'NUMBER OF ASET DOF :                        ',I8/)
C
C     READ COMPONETS AND GRIDS
C
      WRITE(*,1003)
 1003 FORMAT(
     $5X,'LIST OF ASET DEGREES OF FREEDOM'/
     $5X,'  GRID    COMP. '/
     $5X,'-------- -------')
C
      READ(20,IOSTAT=IOERR) (IWORK(1,J),IWORK(2,J),J=1,NEQR)
      DO J=1,NEQR
         WRITE(*,1004) IWORK(1,J),IWORK(2,J)
 1004    FORMAT(5X,2I8)
      END DO
C
C       LOOP OVER DESIGN VARIABLES
C
      DO 20 II=1,NDVI
C
C          GET USER DESIGN VARIABLE ID
C
         READ(20,IOSTAT=IOERR) IUSER
         WRITE(*,1005) IUSER
 1005    FORMAT(/
     $5X,'DESIGN VARIABLE ID:',I8/)
C
C          READ SENSITIVITY MATRIX
C
         ILAST=0
         DO 10 J=1,NEQR
            NROW=NEQR-J+1
            IFIRST=ILAST+1
            ILAST=IFIRST+NROW-1
            READ(20,IOSTAT=IOERR)(SKMAA(I),I=IFIRST,ILAST)
            WRITE(*,1006) J,J,NEQR
 1006       FORMAT(
     $5X,'SENSITIVITY VALUES FOR COLUMN',I8,': ROWS',I8,' TO',I8/)
            WRITE(*,1007)(SKMAA(I),I=IFIRST,ILAST)
 1007       FORMAT(3X,1P,5(2X,E13.6))
C
10         CONTINUE
C
C     !  END LOOP OVER DESIGN VARIABLES
20    CONTINUE
C
      CLOSE(UNIT=20)
C
997   CONTINUE
      IF (IOERR.NE.0) THEN
         WRITE(*,*) ' CAN''T OPEN FILE, IOSTAT =',IOERR
      END IF
C
      END
