C***********************************************************************
C
C     SUBROUTINE NAME: DRESP3
C
C     CREATED ON: 2003-04-14     BY: Brian C. Watson
C
C     PURPOSE: EXAMPLE USER SUBROUTINE FOR DRESP3 RESPONSE EVALUATION.
C
C     PARAMETER LIST: (IWHICH,VAR,N,VAL,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: IWHICH - WHICH USER RESPONSE TO EVALUATE (1-9).
C            VAR(N) - THE VECTOR OF INPUT VARIABLES.
C            N      - THE NUMBER OF VARIABLES.
C
C     OUTPUT: VAL    - THE DRESP3 RESPONSE VALUE.
C             IERR   - THE ERROR SWITCH.
C                    =0 FOR NO ERROR.
C                    =1 FOR ERROR.
C                    =2 FOR NO USER SUPPLIED ROUTINE.
C
C***********************************************************************
      SUBROUTINE DRESP3(IWHICH,VAR,N,VAL,IERR)
CDEC$ ATTRIBUTES DLLEXPORT :: DRESP3
      IMPLICIT NONE
C
      INTEGER IWHICH, N, IERR
C
      DOUBLE PRECISION VAR(N)
C
      DOUBLE PRECISION VAL
C
      IF (IWHICH.EQ.7) THEN
         CALL MYSUB7(VAR, N, VAL, IERR)
      ELSE IF (IWHICH.EQ.8) THEN
         CALL MYSUB8(VAR, N, VAL, IERR)
      ELSE
         IERR = 2
      ENDIF

      RETURN
      END
C***********************************************************************
C
C     SUBROUTINE NAME: MYSUB7
C
C     CREATED ON: 04/29/93       BY: HAROLD THOMAS
C
C     PURPOSE: USER SUBROUTINE NUMBER 7 FOR DRESP3 RESPONSE EVALUATION.
C
C     PARAMETER LIST: (VAR,N,VAL,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: VAR(N) - THE VECTOR OF INPUT VARIABLES.
C            N      - THE NUMBER OF VARIABLES.
C
C     OUTPUT: VAL    - THE DRESP3 RESPONSE VALUE.
C             IERR   - THE ERROR SWITCH.
C                    =0 FOR NO ERROR.
C                    =1 FOR ERROR.
C
C     CALLED BY: GN04EQ
C
C     CALLS: NONE
C
C     ALGORITHM: USER DEFINED.
C
C***********************************************************************
C
      SUBROUTINE MYSUB7(VAR,N,VAL,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION VAR(N)
C
      DOUBLE PRECISION X(6), Y(6), U(6), V(6)
      DATA PI/3.141590D0/
      DATA RL/100.0D0/
C
      IERR = 0
C
      J = 0
C
C     GET COORDINATES
C
      DO 10 I = 1,6
         J = J + 1
         X(I) = VAR(J)
         J = J + 1
         Y(I) = VAR(J)
   10 CONTINUE
C
C     GET DISPLACEMENTS
C
      DO 20 I = 1,6
         J = J + 1
         U(I) = VAR(J)
         J = J + 1
         V(I) = VAR(J)
   20 CONTINUE
C
C     CALCULATE DEFORMED SHAPE
C
      DO 30 I = 1,6
         X(I) = X(I) + U(I)
         Y(I) = Y(I) + V(I)
   30 CONTINUE
C
C     LEAST SQUARES FIT OF 2 TERM SINE SERIES
C
      T1 = 0.0D0
      T2 = 0.0D0
      T3 = 0.0D0
      T4 = 0.0D0
      T5 = 0.0D0
      T6 = 0.0D0
      DO 40 I = 1,6
         T1 = T1 + Y(I)**2
         T2 = T2 + SIN(PI*X(I)/RL)**2
         T3 = T3 + SIN(2.0D0*PI*X(I)/RL)**2
         T4 = T4 + 2.0D0*Y(I)*SIN(PI*X(I)/RL)
         T5 = T5 + 2.0D0*Y(I)*SIN(2.0D0*PI*X(I)/RL)
         T6 = T6 + 2.0D0*SIN(PI*X(I)/RL)*SIN(2.0D0*PI*X(I)/RL)
   40 CONTINUE
C
      B1 = T5 - (2.0D0*T4*T3)/T6
      B2 = T6 - (4.0D0*T2*T3)/T6
      A1 = B1/B2
      A2 = (T4 - 2.0D0*T2*A1)/T6
C
      VAL = A1
C
      RETURN
      END
C***********************************************************************
C
C     SUBROUTINE NAME: MYSUB8
C
C     CREATED ON: 04/29/93       BY: HAROLD THOMAS
C
C     PURPOSE: USER SUBROUTINE NUMBER 8 FOR DRESP3 RESPONSE EVALUATION.
C
C     PARAMETER LIST: (VAR,N,VAL,IERR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: VAR(N) - THE VECTOR OF INPUT VARIABLES.
C            N      - THE NUMBER OF VARIABLES.
C
C     OUTPUT: VAL    - THE DRESP3 RESPONSE VALUE.
C             IERR   - THE ERROR SWITCH.
C                    =0 FOR NO ERROR.
C                    =1 FOR ERROR.
C
C     CALLED BY: GN04EQ
C
C     CALLS: NONE
C
C     ALGORITHM: USER DEFINED.
C
C***********************************************************************
C
      SUBROUTINE MYSUB8(VAR,N,VAL,IERR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      DOUBLE PRECISION VAR(N)
      DOUBLE PRECISION X(6), Y(6), U(6), V(6)
      DATA PI/3.141590D0/
      DATA RL/100.0D0/
C
      IERR = 0
C
      J = 0
C
C     GET COORDINATES
C
      DO 10 I = 1,6
         J = J + 1
         X(I) = VAR(J)
         J = J + 1
         Y(I) = VAR(J)
   10 CONTINUE
C
C     GET DISPLACEMENTS
C
      DO 20 I = 1,6
         J = J + 1
         U(I) = VAR(J)
         J = J + 1
         V(I) = VAR(J)
   20 CONTINUE
C
C     CALCULATE DEFORMED SHAPE
C
      DO 30 I = 1,6
         X(I) = X(I) + U(I)
         Y(I) = Y(I) + V(I)
   30 CONTINUE
C
C     LEAST SQUARES FIT OF 2 TERM SINE SERIES
C
      T1 = 0.0D0
      T2 = 0.0D0
      T3 = 0.0D0
      T4 = 0.0D0
      T5 = 0.0D0
      T6 = 0.0D0
      DO 40 I = 1,6
         T1 = T1 + Y(I)**2
         T2 = T2 + SIN(PI*X(I)/RL)**2
         T3 = T3 + SIN(2.0D0*PI*X(I)/RL)**2
         T4 = T4 + 2.0D0*Y(I)*SIN(PI*X(I)/RL)
         T5 = T5 + 2.0D0*Y(I)*SIN(2.0D0*PI*X(I)/RL)
         T6 = T6 + 2.0D0*SIN(PI*X(I)/RL)*SIN(2.0D0*PI*X(I)/RL)
   40 CONTINUE
C
      B1 = T5 - (2.0D0*T4*T3)/T6
      B2 = T6 - (4.0D0*T2*T3)/T6
      A1 = B1/B2
      A2 = (T4 - 2.0D0*T2*A1)/T6
C
      VAL = A2
C
      RETURN
      END

