C***********************************************************************
C
C     PROGRAM NAME: GNUSER
C
C     CREATED ON: 02/09/2000           BY: Brian C. Watson
C     MODIFIED ON: 2006-08-30          BY: Brian C. Watson
C
C     PURPOSE: SKELETON PROGRAM TO CALCULATE DRESPU RESPONSES FOR
C              GENESIS.
C
C***********************************************************************
      PROGRAM GNUSER
      IMPLICIT NONE
C
C     !  THIS PROGRAM SHOULD KNOW HOW MANY DESIGN VARIABLES
C     !  THERE ARE.  HOWEVER, SOME RESPONSES ARE FLEXIBLE ENOUGH
C     !  TO NOT DEPEND ON THE NUMBER (E.G., SUM ALL THE DVARS)
C
C     !  MAXDV IS THEREFORE EITHER THE EXACT NUMBER OF DVARS
C     !  OR AN UPPER BOUND ON THE NUMBER
C
C     !  WARNING -- IF THERE ARE MORE THAN MAXDV VALUES IN THE FILE
C     !  THIS PROGRAM WILL SILENTLY IGNORE THE EXTRA ONES
C
      INTEGER MAXDV
      PARAMETER (MAXDV = 5000)
      DOUBLE PRECISION DVARS(MAXDV)
      DOUBLE PRECISION GRAD(MAXDV)
C
C     !  THIS PROGRAM MUST KNOW HOW MANY RESPONSES IT CALCULATES
C
C     !  SET NRESPU TO THE NUMBER OF RESPONSES
C
C     !  WARNING -- IF IT CALCULATES MORE THAN GENESIS EXPECTS,
C     !  THEN GENESIS WILL SILENTLY IGNORE THE EXTRA RESPONSES
C     ! (GENESIS EXPECTS ONE RESPONSE PER DRESPU ENTRY IN THE
C     !  INPUT FILE)
C
      INTEGER NRESPU
      PARAMETER (NRESPU = 10)
      DOUBLE PRECISION RESPU(NRESPU)
      INTEGER ICUSER(NRESPU)
C
C     !  LOCAL VARIABLE DECLARATIONS
C
      INTEGER NARG
      CHARACTER*80 DVFILE, RSFILE
      CHARACTER*8  CNGRAD
      CHARACTER*80 ICFILE
      DOUBLE PRECISION VAL
C
      INTEGER NTM, NDV, I, J, IR, NGRAD, IERR
      LOGICAL LEX
C
C     !  FUNCTION DECLARATIONS
C
      INTEGER  IARGC
      EXTERNAL IARGC
C
C     !  SET UNIT NUMBERS FOR ERROR MESSAGES
C
      NTM = 0
C
C     !  GET THE DESIGN VARIABLE AND RESPONSE FILE NAMES
C
      NARG = IARGC()
      IF (NARG.LT.2) THEN
         WRITE (NTM,1998)
 1998    FORMAT (
     $5X,'AN ERROR OCCURRED IN THE USER-RESPONSE PROGRAM:'/
     $5X,'TWO COMMAND LINE ARGUMENTS EXPECTED'/)
         GO TO 9999
      ENDIF
      CALL GETARG(1,DVFILE)
      CALL GETARG(2,RSFILE)
      IF (NARG.GE.4) THEN
         CALL GETARG(3,CNGRAD)
         READ (CNGRAD, '(I8)') NGRAD
         IF (NGRAD .GT. 0) THEN
            CALL GETARG(4,ICFILE)
            INQUIRE (FILE=ICFILE, EXIST=LEX, IOSTAT=IERR, ERR=999)
            IF (.NOT.LEX) THEN
               WRITE (NTM,2997)
 2997          FORMAT (
     $      5X,'AN ERROR OCCURRED IN THE USER-RESPONSE PROGRAM:'/
     $      5X,'ICUSER FILE NOT FOUND'/)
               GO TO 9999
            ENDIF
C
            OPEN (12, FILE=ICFILE, STATUS='OLD', FORM='FORMATTED',
     *            IOSTAT=IERR, ERR=999)
            DO J=1,NGRAD
               READ(12,'(I8)',IOSTAT=IERR,ERR=999) ICUSER(J)
            END DO
            CLOSE(12)
         ENDIF
      ELSE
         NGRAD = 0
      ENDIF
C
C     !  READ THE DESIGN VARIABLE VALUES FROM THE DV FILE
C
      INQUIRE (FILE=DVFILE, EXIST=LEX, IOSTAT=IERR, ERR=999)
      IF (.NOT.LEX) THEN
         WRITE (NTM,2998)
 2998    FORMAT (
     $5X,'AN ERROR OCCURRED IN THE USER-RESPONSE PROGRAM:'/
     $5X,'DESIGN VARIABLE FILE NOT FOUND'/)
         GO TO 9999
      ENDIF
C
      OPEN (12, FILE=DVFILE, STATUS='OLD', FORM='FORMATTED',
     *      IOSTAT=IERR, ERR=999)
C
      NDV = 0
      DO I=1,MAXDV
         READ(12,'(F20.0)',IOSTAT=IERR,ERR=999,END=3000) VAL
         NDV = NDV + 1
         DVARS(NDV) = VAL
      END DO
 3000 CONTINUE
C
      CLOSE(12)
C
C     !  OPEN THE RESPONSE/GRADIENT FILE
C
      OPEN (12, FILE=RSFILE, STATUS='UNKNOWN', FORM='FORMATTED',
     $      IOSTAT=IERR, ERR=999)
C
      IF (NGRAD .EQ. 0) THEN
C
C        !  CALCULATE RESPONSES HERE
C
C        !  INSERT YOUR CALCULATIONS HERE TO PRODUCE THE
C        !  RESPONSE VALUES
C        !
C        !  YOU CAN CALCULATE DIRECTLY, OR YOU CAN USE THE DESIGN
C        !  VARIABLES TO MODIFY INPUT FILE(S) FOR SOME OTHER
C        !  PROGRAM, CALL SYSTEM() TO RUN THAT OTHER PROGRAM, AND
C        !  THEN READ THAT PROGRAM'S OUTPUT FILE(S) TO GET RESPONSE
C        !  VALUES.
C
         DO I=1,NRESPU
            WRITE(12,'(1P,E20.13)') RESPU(I)
         END DO
C
      ELSE
C
C        !  CALCULATE GRADIENTS HERE
C        !  THIS CODE BLOCK WILL ONLY BE USED IF
C        !  DOPT PARAMETER IUGRAD IS 1
C
         DO J=1,NGRAD
C
            IR = ICUSER(J)
C
C           !  INSERT YOUR CALCULATIONS HERE TO PRODUCE THE
C           !  GRADIENT OF RESPONSE INDEX 'IR'
C           !  NOTE: IR IS _NOT_ THE RESPONSE USER ID FROM
C           !        THE DRESPU -- IT IS AN INDEX THAT GOES
C           !        FROM 1 TO NRESPU
C
            DO I=1,NDV
               WRITE(12,'(1P,E20.13)') GRAD(I)
            END DO
C
         END DO
C
      ENDIF
C
      CLOSE (12)
C
C     !  FINISHED
C
      GO TO 9999
C
 999  CONTINUE
      WRITE (NTM,9998) IERR
 9998 FORMAT (
     $5X,'AN I/O ERROR OCCURRED IN THE USER-RESPONSE PROGRAM:'/
     $5X,'IOSTAT = ',I8/)
C
 9999 CONTINUE
      END
