C**********************************************************************
C                              GNMASS
C**********************************************************************
C
C     SUBROUTINE NAME: GNMASS
C
C     CREATED ON: 01/07/97           BY: JUAN-PABLO LEIVA
C
C     PURPOSE: INTERFACE ROUTINE TO CALCULATE REDUCED MASS MATRICES.
C              THE CALCULATION CAN BE LOADCASE DEPENDANT AND/OR
C              DESIGN VARIABLE DEPENDANT.
C
C     PARAMETER LIST:  (UDV,IASET,NDVT,NEQR,NEQRL,IUSERL,
C                       RMASS,IERROR)
C
C     COMMON BLOCKS USED: NONE
C
C     INPUT: UDV(NDVT)    - THE DESIGN VARIABLE VALUES IN USER
C                           DEFINED ORDER.
C            IASET(1,NEQR) - GRIDS ASSOCIATED TO ASET DEGREE OF FREEDOM
C                 (2,NEQR) - COMPONENT ASSOCIATED TO ASET DEGREE OF
C                            FREEDOM. OPTIONALLY, THIS ARRAY MAY BE
C                            CHANGED BY THE USER TO CHANGE ORDER OF
C                            GRID AND COMPONENT.
C            NDVT   - THE TOTAL NUMBER OF DESIGN VARIABLES.
C            NEQR   - THE NUMBER OF ASET DEGREE OF FREEDOM.
C            NEQRL  - DIMENSION OF RMASS [=NEQR*(NEQR+1)/2)]
C            IUSERL - LOADCASE NUMBER
C
C     OUTPUT: RMASS(NEQRL) - USER CALCULATED REDUCED MASS  MATRIX
C                            IN PACKED FORM (COLUMNS OF THE LOWER
C                            TRIANGLE)
C
C             IERROR - ERROR FLAG 
C                    =0 FOR NO ERROR.
C                    =1 FOR ERROR.
C
C     CALLED BY: GN29UM
C
C     CALLS: NONE
C
C     ALGORITHM:
C
C     1. SET THE ERROR SWITCH
C
C     2. CALCULATE MASS MATRIX
C
C**********************************************************************
C
      SUBROUTINE GNMASS(UDV,IASET,NDVT,NEQR,NEQRL,IUSERL,
     *                  RMASS,IERROR)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C
      PARAMETER (ZERO = 0.0D0)
C
C     DOUBLE PRECISION UDV(NDVT),  RMASS(NEQRL) 
C
      DOUBLE PRECISION UDV(*),     RMASS(NEQRL) 
C
      INTEGER  IASET(2,NEQR)
C
C     GET OUTPUT FILE UNIT NUMBER
C
C     GET UNIT NUMBER FOR USER DEFINED MASS MATRIX
C
C     !  Unit 74 is reserved for use by the GNMASS routine
      NMS = 74
C
C     SET ERROR SWITCH 
C
      IERROR = 0
C
C     CALCULATE THE MASS MATRIX
C
C     (REPLACE NEXT LINES BY ACTUAL CALCULATIONS)
C
      IF (IUSERL.LT.10) THEN
C
          OPEN (UNIT=NMS, FILE='USER.1.MASS', STATUS='OLD',
     $          FORM='UNFORMATTED', IOSTAT = IERR, ERR=999)

          READ(NMS, IOSTAT=IERR, ERR=999) IDELEM,INNEQR
          IF (INNEQR.NE.NEQR) THEN
             WRITE(*,*) ' WRONG NUMBER OF DOF IN MASS FILE'
             WRITE(*,*) ' INNEQR = ', INNEQR
             WRITE(*,*) ' NEQR = ', NEQR
             IERROR = 1
             RETURN
          ENDIF
          READ(NMS, IOSTAT=IERR, ERR=999)
     $               (IASET(1,I),IASET(2,I),I=1,NEQR)
          K=1
          DO I=1,NEQR
             KK=K+NEQR-I
             READ(NMS, IOSTAT=IERR, ERR=999) (RMASS(J),J=K,KK)
             K = KK +1
          END DO

          CLOSE (NMS)
C
      ELSE IF (IUSERL.LT.20) THEN
C
          OPEN (UNIT=NMS, FILE='USER.2.MASS', STATUS='OLD',
     $          FORM='UNFORMATTED', IOSTAT = IERR, ERR=999)

          READ(NMS, IOSTAT=IERR, ERR=999) IDELEM,INNEQR
          IF (INNEQR.NE.NEQR) THEN
             WRITE(*,*) ' WRONG NUMBER OF DOF IN MASS FILE'
             WRITE(*,*) ' INNEQR = ', INNEQR
             WRITE(*,*) ' NEQR = ', NEQR
             IERROR = 1
             RETURN
          ENDIF
          READ(NMS, IOSTAT=IERR, ERR=999)
     $               (IASET(1,I),IASET(2,I),I=1,NEQR)
          K=1
          DO I=1,NEQR
             KK=K+NEQR-I
             READ(NMS, IOSTAT=IERR, ERR=999) (RMASS(J),J=K,KK)
             K = KK +1
          END DO

          CLOSE (NMS)
C
      END IF
C
      RETURN
 999  CONTINUE
      CLOSE (NMS)
      WRITE(*,*) ' I/O ERROR IN GNMASS'
      WRITE(*,*) ' IOSTAT = ', IERR
      IERROR = 1
      RETURN
      END
